/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.CompiledExpression;
import org.apache.cayenne.ejbql.parser.EJBQLFromItem;
import org.apache.cayenne.ejbql.parser.EJBQLJoin;
import org.apache.cayenne.ejbql.parser.EJBQLPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class Compiler {
    private boolean appendingResultColumns;
    private String rootId;
    private EntityResolver resolver;
    private Map<String, ClassDescriptor> descriptorsById;
    private Map<String, ObjRelationship> incomingById;
    private Collection<EJBQLPath> paths;
    private EJBQLExpressionVisitor fromItemVisitor;
    private EJBQLExpressionVisitor joinVisitor;
    private EJBQLExpressionVisitor pathVisitor;
    private EJBQLExpressionVisitor rootDescriptorVisitor;
    private List<Object> resultComponents;

    Compiler(EntityResolver resolver) {
        this.resolver = resolver;
        this.descriptorsById = new HashMap<String, ClassDescriptor>();
        this.incomingById = new HashMap<String, ObjRelationship>();
        this.rootDescriptorVisitor = new SelectExpressionVisitor();
        this.fromItemVisitor = new FromItemVisitor();
        this.joinVisitor = new JoinVisitor();
        this.pathVisitor = new PathVisitor();
    }

    CompiledExpression compile(String source, EJBQLExpression parsed) {
        parsed.visit(new CompilationVisitor());
        if (this.paths != null) {
            for (EJBQLPath path : this.paths) {
                String id = Compiler.normalizeIdPath(path.getId());
                ClassDescriptor descriptor = this.descriptorsById.get(id);
                if (descriptor == null) {
                    throw new EJBQLException("Unmapped id variable: " + id);
                }
                StringBuilder buffer = new StringBuilder(id);
                for (int i = 1; i < path.getChildrenCount(); ++i) {
                    String pathChunk = path.getChild(i).getText();
                    buffer.append('.').append(pathChunk);
                    Property property = descriptor.getProperty(pathChunk);
                    if (!(property instanceof ArcProperty)) continue;
                    ObjRelationship incoming = ((ArcProperty)property).getRelationship();
                    descriptor = ((ArcProperty)property).getTargetDescriptor();
                    String pathString = buffer.substring(0, buffer.length());
                    this.descriptorsById.put(pathString, descriptor);
                    this.incomingById.put(pathString, incoming);
                }
            }
        }
        CompiledExpression compiled = new CompiledExpression();
        compiled.setExpression(parsed);
        compiled.setSource(source);
        compiled.setRootId(this.rootId);
        compiled.setDescriptorsById(this.descriptorsById);
        compiled.setIncomingById(this.incomingById);
        if (this.resultComponents != null) {
            SQLResult mapping = new SQLResult();
            for (int i = 0; i < this.resultComponents.size(); ++i) {
                Object nextMapping = this.resultComponents.get(i);
                if (nextMapping instanceof String) {
                    mapping.addColumnResult((String)nextMapping);
                    continue;
                }
                if (!(nextMapping instanceof EJBQLExpression)) continue;
                mapping.addEntityResult(this.compileEntityResult((EJBQLExpression)nextMapping, i));
            }
            compiled.setResult(mapping);
        }
        return compiled;
    }

    private EntityResult compileEntityResult(EJBQLExpression expression, int position) {
        String id = expression.getText().toLowerCase();
        ClassDescriptor descriptor = this.descriptorsById.get(id);
        final EntityResult entityResult = new EntityResult(descriptor.getObjectClass());
        final String prefix = "ec" + position + "_";
        final int[] index = new int[]{0};
        final HashSet<String> visited = new HashSet<String>();
        PropertyVisitor visitor = new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                if (visited.add(oa.getDbAttributePath())) {
                    int n = index[0];
                    index[0] = n + 1;
                    entityResult.addObjectField(oa.getEntity().getName(), oa.getName(), prefix + n);
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                for (DbJoin join : dbRel.getJoins()) {
                    DbAttribute src = join.getSource();
                    if (!src.isForeignKey() || !visited.add(src.getName())) continue;
                    int n = index[0];
                    index[0] = n + 1;
                    entityResult.addDbField(src.getName(), prefix + n);
                }
                return true;
            }
        };
        descriptor.visitAllProperties(visitor);
        for (String pkName : descriptor.getEntity().getPrimaryKeyNames()) {
            if (!visited.add(pkName)) continue;
            int n = index[0];
            index[0] = n + 1;
            entityResult.addDbField(pkName, prefix + n);
        }
        Iterator<ObjAttribute> discriminatorColumns = descriptor.getDiscriminatorColumns();
        while (discriminatorColumns.hasNext()) {
            ObjAttribute column = discriminatorColumns.next();
            if (!visited.add(column.getName())) continue;
            int n = index[0];
            index[0] = n + 1;
            entityResult.addDbField(column.getDbAttributePath(), prefix + n);
        }
        return entityResult;
    }

    private void addPath(EJBQLPath path) {
        if (this.paths == null) {
            this.paths = new ArrayList<EJBQLPath>();
        }
        this.paths.add(path);
    }

    static String normalizeIdPath(String idPath) {
        int pathSeparator = idPath.indexOf(46);
        return pathSeparator < 0 ? idPath.toLowerCase() : idPath.substring(0, pathSeparator).toLowerCase() + idPath.substring(pathSeparator);
    }

    class SelectExpressionVisitor
    extends EJBQLBaseVisitor {
        SelectExpressionVisitor() {
        }

        public boolean visitIdentifier(EJBQLExpression expression) {
            if (Compiler.this.appendingResultColumns) {
                Compiler.this.rootId = Compiler.normalizeIdPath(expression.getText());
                this.addEntityResult(expression);
            }
            return false;
        }

        public boolean visitAggregate(EJBQLExpression expression) {
            this.addResultSetColumn();
            return false;
        }

        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.addPath((EJBQLPath)expression);
            this.addResultSetColumn();
            return false;
        }

        private void addEntityResult(EJBQLExpression expression) {
            if (Compiler.this.appendingResultColumns) {
                if (Compiler.this.resultComponents == null) {
                    Compiler.this.resultComponents = new ArrayList();
                }
                Compiler.this.resultComponents.add(expression);
            }
        }

        private void addResultSetColumn() {
            if (Compiler.this.appendingResultColumns) {
                if (Compiler.this.resultComponents == null) {
                    Compiler.this.resultComponents = new ArrayList();
                }
                String column = "sc" + Compiler.this.resultComponents.size();
                Compiler.this.resultComponents.add(column);
            }
        }
    }

    class PathVisitor
    extends EJBQLBaseVisitor {
        PathVisitor() {
        }

        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.addPath((EJBQLPath)expression);
            return false;
        }
    }

    class JoinVisitor
    extends EJBQLBaseVisitor {
        private String id;
        private ObjRelationship incoming;
        private ClassDescriptor descriptor;

        JoinVisitor() {
        }

        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.id = ((EJBQLPath)expression).getId();
                this.descriptor = (ClassDescriptor)Compiler.this.descriptorsById.get(this.id);
                if (this.descriptor == null) {
                    throw new EJBQLException("Unmapped id variable: " + this.id);
                }
            }
            return true;
        }

        public boolean visitIdentificationVariable(EJBQLExpression expression) {
            Property property = this.descriptor.getProperty(expression.getText());
            if (!(property instanceof ArcProperty)) {
                throw new EJBQLException("Incorrect relationship path: " + expression.getText());
            }
            this.incoming = ((ArcProperty)property).getRelationship();
            this.descriptor = ((ArcProperty)property).getTargetDescriptor();
            return true;
        }

        public boolean visitIdentifier(EJBQLExpression expression) {
            if (this.incoming != null) {
                String aliasId = expression.getText();
                ClassDescriptor old = Compiler.this.descriptorsById.put(aliasId, this.descriptor);
                if (old != null && old != this.descriptor) {
                    throw new EJBQLException("Duplicate identification variable definition: " + aliasId + ", it is already used for " + old.getEntity().getName());
                }
                Compiler.this.incomingById.put(aliasId, this.incoming);
                this.id = null;
                this.descriptor = null;
                this.incoming = null;
            }
            return true;
        }
    }

    class FromItemVisitor
    extends EJBQLBaseVisitor {
        private String entityName;

        FromItemVisitor() {
        }

        public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
            if (finishedChildIndex + 1 == expression.getChildrenCount()) {
                ClassDescriptor descriptor = Compiler.this.resolver.getClassDescriptor(this.entityName);
                if (descriptor == null) {
                    throw new EJBQLException("Unmapped abstract schema name: " + this.entityName);
                }
                String id = Compiler.normalizeIdPath(expression.getId());
                ClassDescriptor old = Compiler.this.descriptorsById.put(id, descriptor);
                if (old != null && old != descriptor) {
                    throw new EJBQLException("Duplicate identification variable definition: " + id + ", it is already used for " + old.getEntity().getName());
                }
                if (Compiler.this.rootId == null) {
                    Compiler.this.rootId = id;
                }
                this.entityName = null;
            }
            return true;
        }

        public boolean visitIdentificationVariable(EJBQLExpression expression) {
            this.entityName = expression.getText();
            return true;
        }
    }

    class CompilationVisitor
    extends EJBQLBaseVisitor {
        CompilationVisitor() {
        }

        public boolean visitSelect(EJBQLExpression expression) {
            Compiler.this.appendingResultColumns = true;
            return true;
        }

        public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.appendingResultColumns = false;
            return true;
        }

        public boolean visitSelectExpression(EJBQLExpression expression) {
            expression.visit(Compiler.this.rootDescriptorVisitor);
            return false;
        }

        public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
            expression.visit(Compiler.this.fromItemVisitor);
            return false;
        }

        public boolean visitInnerFetchJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        public boolean visitInnerJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        public boolean visitOuterFetchJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        public boolean visitOuterJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        public boolean visitWhere(EJBQLExpression expression) {
            expression.visit(Compiler.this.pathVisitor);
            return true;
        }

        public boolean visitOrderBy(EJBQLExpression expression) {
            expression.visit(Compiler.this.pathVisitor);
            return false;
        }

        public boolean visitSubselect(EJBQLExpression expression) {
            return super.visitSubselect(expression);
        }
    }
}

