/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;

public class EJBQLAction
extends BaseSQLAction {
    protected SQLActionVisitor actionFactory;
    protected EJBQLQuery query;

    public EJBQLAction(EJBQLQuery query, SQLActionVisitor actionFactory, JdbcAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
        this.actionFactory = actionFactory;
    }

    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        EJBQLCompiledExpression compiledExpression = this.query.getExpression(this.getEntityResolver());
        final EJBQLTranslatorFactory translatorFactory = ((JdbcAdapter)this.getAdapter()).getEjbqlTranslatorFactory();
        final EJBQLTranslationContext context = new EJBQLTranslationContext(this.entityResolver, this.query, compiledExpression, translatorFactory);
        compiledExpression.getExpression().visit(new EJBQLBaseVisitor(false){

            public boolean visitSelect(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getSelectTranslator(context);
                expression.visit(visitor);
                return false;
            }

            public boolean visitDelete(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getDeleteTranslator(context);
                expression.visit(visitor);
                return false;
            }

            public boolean visitUpdate(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getUpdateTranslator(context);
                expression.visit(visitor);
                return false;
            }
        });
        SQLTemplate sqlQuery = context.getQuery();
        QueryMetadata md = this.query.getMetaData(this.getEntityResolver());
        sqlQuery.setFetchLimit(md.getFetchLimit());
        sqlQuery.setFetchOffset(md.getFetchOffset());
        sqlQuery.setResult(compiledExpression.getResult());
        sqlQuery.setPageSize(md.getPageSize());
        this.actionFactory.sqlAction(sqlQuery).performAction(connection, observer);
    }
}

