/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrefetchProcessorJointNode
extends PrefetchProcessorNode {
    ColumnDescriptor[] columns;
    int[] idIndices;
    int rowCapacity;
    Map<Map, Persistent> resolved;
    List<DataRow> resolvedRows;

    PrefetchProcessorJointNode(PrefetchTreeNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    @Override
    void afterInit() {
        int capacity;
        super.afterInit();
        int n = capacity = this.dataRows != null ? this.dataRows.size() : 10;
        if (capacity > 100) {
            capacity /= 2;
        }
        this.objects = new ArrayList(capacity);
        this.resolved = new HashMap<Map, Persistent>(capacity);
        this.resolvedRows = new ArrayList<DataRow>(capacity);
        this.buildRowMapping();
        this.buildPKIndex();
    }

    List<DataRow> getResolvedRows() {
        return this.resolvedRows;
    }

    void addObject(Persistent object, DataRow row) {
        this.objects.add(object);
        this.resolvedRows.add(row);
    }

    Map<String, Object> idFromFlatRow(DataRow flatRow) {
        TreeMap<String, Object> id = new TreeMap<String, Object>();
        for (int idIndex : this.idIndices) {
            Object value = flatRow.get(this.columns[idIndex].getDataRowKey());
            id.put(this.columns[idIndex].getName(), value);
        }
        return id;
    }

    Persistent getResolved(Map id) {
        return this.resolved.get(id);
    }

    void putResolved(Map id, Persistent object) {
        this.resolved.put(id, object);
    }

    DataRow rowFromFlatRow(DataRow flatRow) {
        DataRow row = new DataRow(this.rowCapacity);
        for (ColumnDescriptor column : this.columns) {
            row.put(column.getName(), flatRow.get(column.getDataRowKey()));
        }
        return row;
    }

    private void buildRowMapping() {
        String prefix;
        TreeMap<String, ColumnDescriptor> targetSource = new TreeMap<String, ColumnDescriptor>();
        PrefetchTreeNode jointRoot = this;
        while (jointRoot.getParent() != null && !jointRoot.isDisjointPrefetch()) {
            jointRoot = jointRoot.getParent();
        }
        if (jointRoot != this) {
            Expression objectPath = Expression.fromString(this.getPath(jointRoot));
            ASTPath translated = (ASTPath)((PrefetchProcessorNode)jointRoot).getResolver().getEntity().translateToDbPath(objectPath);
            prefix = translated.getOperand(0) + ".";
        } else {
            prefix = "";
        }
        if (this.getParent() != null && !this.getParent().isPhantom() && this.getIncoming() != null && !this.getIncoming().getRelationship().isFlattened()) {
            DbRelationship r = this.getIncoming().getRelationship().getDbRelationships().get(0);
            for (DbJoin join : r.getJoins()) {
                this.appendColumn(targetSource, join.getTargetName(), prefix + join.getTargetName());
            }
        }
        for (ObjAttribute attribute : this.getResolver().getEntity().getAttributes()) {
            String target = attribute.getDbAttributePath();
            this.appendColumn(targetSource, target, prefix + target);
        }
        for (ObjRelationship rel : this.getResolver().getEntity().getRelationships()) {
            DbRelationship dbRel = rel.getDbRelationships().get(0);
            for (DbAttribute attribute : dbRel.getSourceAttributes()) {
                String target = attribute.getName();
                this.appendColumn(targetSource, target, prefix + target);
            }
        }
        for (DbAttribute pk : this.getResolver().getEntity().getDbEntity().getPrimaryKeys()) {
            this.appendColumn(targetSource, pk.getName(), prefix + pk.getName());
        }
        int size = targetSource.size();
        this.rowCapacity = (int)Math.ceil((double)size / 0.75);
        this.columns = new ColumnDescriptor[size];
        targetSource.values().toArray(this.columns);
    }

    private ColumnDescriptor appendColumn(Map<String, ColumnDescriptor> map, String name, String label) {
        ColumnDescriptor column = map.get(name);
        if (column == null) {
            column = new ColumnDescriptor();
            column.setName(name);
            column.setDataRowKey(label);
            map.put(name, column);
        }
        return column;
    }

    private void buildPKIndex() {
        Collection<DbAttribute> pks = this.getResolver().getEntity().getDbEntity().getPrimaryKeys();
        this.idIndices = new int[pks.size()];
        Arrays.fill(this.idIndices, -1);
        Iterator<DbAttribute> it = pks.iterator();
        for (int i = 0; i < this.idIndices.length; ++i) {
            DbAttribute pk = it.next();
            for (int j = 0; j < this.columns.length; ++j) {
                if (!pk.getName().equals(this.columns[j].getName())) continue;
                this.idIndices[i] = j;
                break;
            }
            if (this.idIndices[i] != -1) continue;
            throw new CayenneRuntimeException("PK column is not part of result row: " + pk.getName());
        }
    }
}

