/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.project.ProjectDataSource;

public class ProjectDataSourceFactory
implements DataSourceFactory {
    protected File projectDir;
    protected boolean loadFromXML;
    protected Configuration parentConfiguration;

    public ProjectDataSourceFactory(File projectDir) {
        this.projectDir = projectDir;
    }

    public ProjectDataSourceFactory(File projectDir, boolean loadFromXML) {
        this.projectDir = projectDir;
        this.loadFromXML = loadFromXML;
    }

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location) throws Exception {
        return new ProjectDataSource(this.getDriverInfo(location));
    }

    protected DataSourceInfo getDriverInfo(String location) throws Exception {
        DataSourceInfo info = null;
        if (this.loadFromXML) {
            try {
                info = new XMLConfigLoader().loadDriverInfo(location);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return info != null ? info : new DataSourceInfo();
    }

    final class XMLConfigLoader
    extends DriverDataSourceFactory {
        XMLConfigLoader() throws Exception {
            this.initializeWithParentConfiguration(ProjectDataSourceFactory.this.parentConfiguration);
        }

        DataSourceInfo loadDriverInfo(String location) throws Exception {
            this.load(location);
            return this.driverInfo;
        }
    }
}

