/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAllowNullToDb
extends AbstractToDbToken.EntityAndColumn {
    public SetAllowNullToDb(DbEntity entity, DbAttribute column) {
        super(entity, column);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(this.getEntity().getFullyQualifiedName());
        sqlBuffer.append(" ALTER COLUMN ");
        sqlBuffer.append(this.getColumn().getName());
        sqlBuffer.append(" DROP NOT NULL");
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Set Allow Null";
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetNotNullToModel(this.getEntity(), this.getColumn());
    }
}

