/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.instrument;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitClassTransformer
implements ClassTransformer {
    protected ClassLoader tempClassLoader;
    protected Log logger;
    protected ClassFileTransformer transformer;
    protected Map<String, JpaClassDescriptor> managedClasses;

    public UnitClassTransformer(Map<String, JpaClassDescriptor> managedClasses, ClassLoader tempClassLoader, ClassFileTransformer transformer) {
        this.transformer = transformer;
        this.managedClasses = managedClasses;
        this.tempClassLoader = tempClassLoader;
        this.logger = LogFactory.getLog(this.getClass());
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.tempClassLoader == loader) {
            return null;
        }
        if (this.isManagedClass(className)) {
            this.logger.info((Object)("Will transform managed class: " + className));
            try {
                return this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
            catch (IllegalClassFormatException e) {
                this.logger.warn((Object)("Error transforming class " + className), (Throwable)e);
                throw e;
            }
            catch (Throwable th) {
                this.logger.warn((Object)("Error transforming class " + className), th);
                throw new JpaProviderException("Error transforming class " + className, th);
            }
        }
        return null;
    }

    protected boolean isManagedClass(String className) {
        return this.managedClasses.containsKey(className.replace('/', '.'));
    }
}

