/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.instrument;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import javax.persistence.spi.ClassTransformer;
import org.apache.cayenne.instrument.InstrumentUtil;
import org.apache.cayenne.jpa.JpaUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstrumentingUnit
extends JpaUnit {
    protected Log logger;

    public void addTransformer(final ClassTransformer transformer) {
        ClassFileTransformer transformerWrapper = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
        };
        this.getLogger().info((Object)("*** Adding transformer: " + transformer));
        Instrumentation i = InstrumentUtil.getInstrumentation();
        if (i == null) {
            throw new IllegalStateException("Attempt to add a transformer failed - instrumentation is not initialized.");
        }
        i.addTransformer(transformerWrapper);
    }

    protected Log getLogger() {
        if (this.logger == null) {
            this.logger = LogFactory.getLog(this.getClass());
        }
        return this.logger;
    }
}

