/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.cayenne.access.ConnectionLogger;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.conf.JpaDataSourceFactory;
import org.apache.cayenne.util.Util;

public class DefaultDataSourceFactory
implements JpaDataSourceFactory {
    public DataSource getJtaDataSource(String name, PersistenceUnitInfo info) {
        return this.getDataSource(name, info);
    }

    public DataSource getNonJtaDataSource(String name, PersistenceUnitInfo info) {
        return this.getDataSource(name, info);
    }

    protected DataSource getJndiDataSource(String name, PersistenceUnitInfo info) {
        if (name == null) {
            return null;
        }
        try {
            return (DataSource)new InitialContext().lookup(name);
        }
        catch (NamingException namingEx) {
            return null;
        }
    }

    protected DataSource getDataSource(String name, PersistenceUnitInfo info) {
        DataSource ds = null;
        if (name != null) {
            ds = this.getJndiDataSource(name, info);
        }
        if (ds == null) {
            ds = this.getCayenneDataSource(info.getProperties());
        }
        return ds;
    }

    protected DataSource getCayenneDataSource(Properties properties) {
        int maxConnection;
        int minConnection;
        String driverName = properties.getProperty("org.apache.cayenne.datasource.jdbc.driver");
        if (Util.isEmptyString(driverName)) {
            return null;
        }
        String url = properties.getProperty("org.apache.cayenne.datasource.jdbc.url");
        if (Util.isEmptyString(url)) {
            return null;
        }
        try {
            minConnection = Integer.parseInt(properties.getProperty("org.apache.cayenne.datasource.jdbc.minConnections"));
        }
        catch (Exception e) {
            minConnection = 1;
        }
        try {
            maxConnection = Integer.parseInt(properties.getProperty("org.apache.cayenne.datasource.jdbc.maxConnections"));
        }
        catch (Exception e) {
            maxConnection = 1;
        }
        try {
            return new PoolManager(driverName, url, minConnection, maxConnection, properties.getProperty("org.apache.cayenne.datasource.jdbc.username"), properties.getProperty("org.apache.cayenne.datasource.jdbc.password"), new ConnectionLogger());
        }
        catch (SQLException e) {
            QueryLogger.logConnectFailure(e);
            throw new JpaProviderException("Error creating connection pool", e);
        }
    }
}

