/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;

class SQLServerTrimmingQualifierTranslator
extends TrimmingQualifierTranslator {
    private List<Expression> expressionStack = new ArrayList<Expression>();

    SQLServerTrimmingQualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    public void startNode(Expression node, Expression parentNode) {
        this.push(node);
        super.startNode(node, parentNode);
    }

    protected void processColumn(DbAttribute dbAttr) throws IOException {
        boolean likeCI;
        Expression node = this.peek(1);
        boolean bl = likeCI = node != null && dbAttr.getType() == 2005 && (node.getType() == 12 || node.getType() == 38);
        if (likeCI) {
            try {
                this.out.append("CAST(");
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", ioex);
            }
        }
        super.processColumn(dbAttr);
        if (likeCI) {
            try {
                this.out.append(" AS NVARCHAR(MAX))");
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", ioex);
            }
        }
    }

    public void endNode(Expression node, Expression parentNode) {
        super.endNode(node, parentNode);
        this.pop();
    }

    private void push(Expression node) {
        this.expressionStack.add(node);
    }

    private void pop() {
        int len = this.expressionStack.size();
        if (len > 0) {
            this.expressionStack.remove(len - 1);
        }
    }

    private Expression peek(int tailIndex) {
        int index = this.expressionStack.size() - tailIndex - 1;
        if (index < 0) {
            return null;
        }
        return this.expressionStack.get(index);
    }
}

