/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetNotNullToDb;

public class DerbyMergerFactory
extends MergerFactory {
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(entity.getFullyQualifiedName());
                sqlBuffer.append(" ALTER ");
                sqlBuffer.append(columnNew.getName());
                sqlBuffer.append(" SET DATA TYPE ");
            }
        };
    }

    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(this.getEntity().getFullyQualifiedName());
                sqlBuffer.append(" ALTER COLUMN ");
                sqlBuffer.append(this.getColumn().getName());
                sqlBuffer.append(" NOT NULL");
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(this.getEntity().getFullyQualifiedName());
                sqlBuffer.append(" ALTER COLUMN ");
                sqlBuffer.append(this.getColumn().getName());
                sqlBuffer.append(" NULL");
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }
}

