/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataNodeQueryAction
implements OperationObserver {
    OperationObserver observer;
    DataNode node;
    private Query currentQuery;

    public DataNodeQueryAction(DataNode node, OperationObserver observer) {
        this.observer = observer;
        this.node = node;
    }

    public void runQuery(Connection connection, Query query) throws SQLException, Exception {
        this.currentQuery = query;
        SQLAction action = this.node.getAdapter().getAction(query, this.node);
        action.performAction(connection, this);
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        this.observer.nextBatchCount(this.currentQuery, resultCount);
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        this.observer.nextCount(this.currentQuery, resultCount);
    }

    @Override
    public void nextDataRows(Query query, List<DataRow> dataRows) {
        this.observer.nextDataRows(this.currentQuery, dataRows);
    }

    @Override
    public void nextDataRows(Query q, ResultIterator it) {
        this.observer.nextDataRows(this.currentQuery, it);
    }

    @Override
    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        this.observer.nextGeneratedDataRows(this.currentQuery, keysIterator);
    }

    @Override
    public void nextGlobalException(Exception ex) {
        this.observer.nextGlobalException(ex);
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        this.observer.nextQueryException(this.currentQuery, ex);
    }

    @Override
    public boolean isIteratedResult() {
        return this.observer.isIteratedResult();
    }
}

