/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.sql.Driver;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;

public class DbGeneratorTask
extends CayenneTask {
    protected DbAdapter adapter;
    protected File map;
    protected String driver;
    protected String url;
    protected String userName;
    protected String password;
    protected boolean dropTables;
    protected boolean dropPK;
    protected boolean createTables = true;
    protected boolean createPK = true;
    protected boolean createFK = true;

    public void execute() {
        if (this.adapter == null) {
            this.adapter = new JdbcAdapter();
        }
        this.log("connection settings - [driver: " + this.driver + ", url: " + this.url + ", username: " + this.userName + "]", 3);
        this.log("generator options - [dropTables: " + this.dropTables + ", dropPK: " + this.dropPK + ", createTables: " + this.createTables + ", createPK: " + this.createPK + ", createFK: " + this.createFK + "]", 3);
        this.validateAttributes();
        try {
            DataMap dataMap = this.loadDataMap();
            DbGenerator generator = new DbGenerator(this.adapter, dataMap);
            generator.setShouldCreateFKConstraints(this.createFK);
            generator.setShouldCreatePKSupport(this.createPK);
            generator.setShouldCreateTables(this.createTables);
            generator.setShouldDropPKSupport(this.dropPK);
            generator.setShouldDropTables(this.dropTables);
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.userName, this.password);
            generator.runGenerator(dataSource);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException(ex);
            String message = "Error generating database";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            super.log(message);
            throw new BuildException(message, th);
        }
    }

    protected void validateAttributes() throws BuildException {
        StringBuilder error = new StringBuilder("");
        if (this.map == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if (this.driver == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (this.url == null) {
            error.append("The 'adapter' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    protected DataMap loadDataMap() throws Exception {
        InputSource in = new InputSource(this.map.getCanonicalPath());
        return new MapLoader().loadDataMap(in);
    }

    public void setCreateFK(boolean createFK) {
        this.createFK = createFK;
    }

    public void setCreatePK(boolean createPK) {
        this.createPK = createPK;
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public void setDropPK(boolean dropPK) {
        this.dropPK = dropPK;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public void setMap(File map) {
        this.map = map;
    }

    public void setAdapter(String adapter) {
        if (adapter != null) {
            try {
                Class<?> c = Class.forName(adapter);
                this.adapter = (DbAdapter)c.newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Can't load DbAdapter: " + adapter);
            }
        }
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String username) {
        this.userName = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

