/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.BaseProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

public abstract class BaseArcProperty
extends BaseProperty
implements ArcProperty {
    protected String complimentaryReverseArcName;
    protected ClassDescriptor targetDescriptor;
    protected ObjRelationship relationship;

    public BaseArcProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, accessor);
        this.targetDescriptor = targetDescriptor;
        this.complimentaryReverseArcName = reverseName;
        this.relationship = (ObjRelationship)owner.getEntity().getRelationship(this.getName());
    }

    public abstract boolean visit(PropertyVisitor var1);

    public abstract boolean isFault(Object var1);

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public ArcProperty getComplimentaryReverseArc() {
        return (ArcProperty)this.targetDescriptor.getProperty(this.complimentaryReverseArcName);
    }

    public ClassDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    protected void setReverse(final Object source, final Object oldTarget, final Object newTarget) {
        ArcProperty reverseArc = this.getComplimentaryReverseArc();
        if (reverseArc != null) {
            PropertyVisitor visitor;
            if (oldTarget != null) {
                visitor = new PropertyVisitor(){

                    public boolean visitToMany(ToManyProperty property) {
                        property.removeTarget(oldTarget, source, false);
                        return false;
                    }

                    public boolean visitToOne(ToOneProperty property) {
                        property.setTarget(oldTarget, null, false);
                        return false;
                    }

                    public boolean visitAttribute(AttributeProperty property) {
                        return false;
                    }
                };
                reverseArc.visit(visitor);
            }
            if (newTarget != null) {
                visitor = new PropertyVisitor(){

                    public boolean visitToMany(ToManyProperty property) {
                        property.addTarget(newTarget, source, false);
                        return false;
                    }

                    public boolean visitToOne(ToOneProperty property) {
                        property.setTarget(newTarget, source, false);
                        return false;
                    }

                    public boolean visitAttribute(AttributeProperty property) {
                        return false;
                    }
                };
                reverseArc.visit(visitor);
            }
        }
    }
}

