/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.ChildDiffLoader;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataContextDeleteAction;
import org.apache.cayenne.access.DataContextFactory;
import org.apache.cayenne.access.DataContextGraphAction;
import org.apache.cayenne.access.DataContextMergeHandler;
import org.apache.cayenne.access.DataContextQueryAction;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.NoopDelegate;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionResultIteratorDecorator;
import org.apache.cayenne.access.util.IteratedSelectObserver;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ObjectContextGraphAction;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext
extends BaseContext
implements DataChannel {
    protected static final ThreadLocal<DataContext> threadDataContext = new ThreadLocal();
    private DataContextDelegate delegate;
    protected boolean usingSharedSnaphsotCache;
    protected boolean validatingObjectsOnCommit;
    protected ObjectStore objectStore;
    protected transient EntityResolver entityResolver;
    protected transient DataContextMergeHandler mergeHandler;
    ObjectContextGraphAction graphAction;
    protected Map<String, Object> userProperties;
    protected transient String lazyInitParentDomainName;

    public static DataContext getThreadDataContext() throws IllegalStateException {
        DataContext dc = threadDataContext.get();
        if (dc == null) {
            throw new IllegalStateException("Current thread has no bound DataContext.");
        }
        return dc;
    }

    public static void bindThreadDataContext(DataContext context) {
        threadDataContext.set(context);
    }

    public static DataContext createDataContext() {
        return Configuration.getSharedConfiguration().getDomain().createDataContext();
    }

    public static DataContext createDataContext(boolean useSharedCache) {
        return Configuration.getSharedConfiguration().getDomain().createDataContext(useSharedCache);
    }

    public static DataContext createDataContext(String domainName) {
        DataDomain domain = Configuration.getSharedConfiguration().getDomain(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Non-existent domain: " + domainName);
        }
        return domain.createDataContext();
    }

    public static DataContext createDataContext(String domainName, boolean useSharedCache) {
        DataDomain domain = Configuration.getSharedConfiguration().getDomain(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Non-existent domain: " + domainName);
        }
        return domain.createDataContext(useSharedCache);
    }

    public DataContext() {
        this(null, null);
    }

    public DataContext(DataChannel channel, ObjectStore objectStore) {
        this.setChannel(channel);
        if (objectStore != null) {
            this.objectStore = objectStore;
            objectStore.setContext(this);
            DataDomain domain = this.getParentDataDomain();
            this.usingSharedSnaphsotCache = domain != null && objectStore.getDataRowCache() == domain.getSharedSnapshotCache();
        }
        this.graphAction = new DataContextGraphAction(this);
    }

    @Override
    public synchronized QueryCache getQueryCache() {
        if (this.queryCache == null) {
            this.queryCache = this.getParentDataDomain().getQueryCacheFactory().getQueryCache(Collections.EMPTY_MAP);
        }
        return this.queryCache;
    }

    protected Map<String, Object> getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, Object>();
        }
        return this.userProperties;
    }

    public DataContext createChildDataContext() {
        DataContextFactory factory = this.getParentDataDomain().getDataContextFactory();
        ObjectStore objectStore = new ObjectStore();
        DataContext child = factory != null ? factory.createDataContext(this, objectStore) : new DataContext(this, objectStore);
        child.setValidatingObjectsOnCommit(this.isValidatingObjectsOnCommit());
        child.usingSharedSnaphsotCache = this.isUsingSharedSnapshotCache();
        return child;
    }

    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }

    public void setChannel(DataChannel channel) {
        if (this.channel != channel) {
            if (this.mergeHandler != null) {
                this.mergeHandler.setActive(false);
            }
            this.entityResolver = null;
            this.mergeHandler = null;
            this.channel = channel;
            if (channel != null) {
                DataRowStore cache;
                this.entityResolver = channel.getEntityResolver();
                EventManager eventManager = channel.getEventManager();
                if (eventManager != null) {
                    this.mergeHandler = new DataContextMergeHandler(this);
                    EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
                }
                if (!this.usingSharedSnaphsotCache && this.getObjectStore() != null && (cache = this.getObjectStore().getDataRowCache()) != null) {
                    cache.setEventManager(eventManager);
                }
            }
        }
    }

    @Override
    public DataChannel getChannel() {
        this.awakeFromDeserialization();
        return super.getChannel();
    }

    public DataDomain getParentDataDomain() {
        this.awakeFromDeserialization();
        if (this.channel == null) {
            return null;
        }
        if (this.channel instanceof DataDomain) {
            return (DataDomain)this.channel;
        }
        List response = this.channel.onQuery(this, new DataDomainQuery()).firstList();
        if (response != null && response.size() > 0 && response.get(0) instanceof DataDomain) {
            return (DataDomain)response.get(0);
        }
        return null;
    }

    public void setDelegate(DataContextDelegate delegate) {
        this.delegate = delegate;
    }

    public DataContextDelegate getDelegate() {
        return this.delegate;
    }

    DataContextDelegate nonNullDelegate() {
        return this.delegate != null ? this.delegate : NoopDelegate.noopDelegate;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public boolean hasChanges() {
        return this.getObjectStore().hasChanges();
    }

    @Override
    public Collection<?> newObjects() {
        return this.getObjectStore().objectsInState(2);
    }

    @Override
    public Collection<?> deletedObjects() {
        return this.getObjectStore().objectsInState(6);
    }

    @Override
    public Collection<?> modifiedObjects() {
        return this.getObjectStore().objectsInState(4);
    }

    @Override
    public Collection<?> uncommittedObjects() {
        int len = this.getObjectStore().registeredObjectsCount();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Persistent> objects = new ArrayList<Persistent>(len > 100 ? len / 2 : len);
        Iterator it = this.getObjectStore().getObjectIterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            int state = object.getPersistenceState();
            if (state != 4 && state != 2 && state != 6) continue;
            objects.add(object);
        }
        return objects;
    }

    public DataRow currentSnapshot(final Persistent object) {
        if (object.getPersistenceState() == 5 && object.getObjectContext() != null) {
            return this.getObjectStore().getSnapshot(object.getObjectId());
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        final DataRow snapshot = new DataRow(10);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute objAttr = property.getAttribute();
                snapshot.put(objAttr.getDbAttributePath(), property.readPropertyDirectly(object));
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship rel = property.getRelationship();
                if (rel.isSourceIndependentFromTargetChange()) {
                    return true;
                }
                Object targetObject = property.readPropertyDirectly(object);
                if (targetObject == null) {
                    return true;
                }
                if (targetObject instanceof Fault) {
                    DataRow storedSnapshot = DataContext.this.getObjectStore().getSnapshot(object.getObjectId());
                    if (storedSnapshot == null) {
                        throw new CayenneRuntimeException("No matching objects found for ObjectId " + object.getObjectId() + ". Object may have been deleted externally.");
                    }
                    DbRelationship dbRel = rel.getDbRelationships().get(0);
                    for (DbJoin join : dbRel.getJoins()) {
                        String key = join.getSourceName();
                        snapshot.put(key, storedSnapshot.get(key));
                    }
                    return true;
                }
                Persistent target = (Persistent)targetObject;
                Map<String, Object> idParts = target.getObjectId().getIdSnapshot();
                if (idParts.isEmpty()) {
                    return true;
                }
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                Map<String, Object> fk = dbRel.srcFkSnapshotWithTargetSnapshot(idParts);
                snapshot.putAll(fk);
                return true;
            }
        });
        Map<String, Object> thisIdParts = object.getObjectId().getIdSnapshot();
        if (thisIdParts != null) {
            for (Map.Entry<String, Object> entry : thisIdParts.entrySet()) {
                String nextKey = entry.getKey();
                if (snapshot.containsKey(nextKey)) continue;
                snapshot.put(nextKey, entry.getValue());
            }
        }
        return snapshot;
    }

    public List objectsFromDataRows(ObjEntity entity, List dataRows, boolean refresh, boolean resolveInheritanceHierarchy) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        return new ObjectResolver(this, descriptor, refresh, resolveInheritanceHierarchy).synchronizedObjectsFromDataRows(dataRows);
    }

    public List objectsFromDataRows(Class<?> objectClass, List<? extends DataRow> dataRows, boolean refresh, boolean resolveInheritanceHierarchy) {
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(objectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped Java class: " + objectClass);
        }
        return this.objectsFromDataRows(entity, dataRows, refresh, resolveInheritanceHierarchy);
    }

    public DataObject objectFromDataRow(Class<?> objectClass, DataRow dataRow, boolean refresh) {
        List list = this.objectsFromDataRows(objectClass, Collections.singletonList(dataRow), refresh, true);
        return (DataObject)list.get(0);
    }

    public DataObject objectFromDataRow(String entityName, DataRow dataRow, boolean refresh) {
        ObjEntity entity = this.getEntityResolver().getObjEntity(entityName);
        List list = this.objectsFromDataRows(entity, Collections.singletonList(dataRow), refresh, true);
        return (DataObject)list.get(0);
    }

    public DataObject createAndRegisterNewObject(String objEntityName) {
        return (DataObject)this.newObject(objEntityName);
    }

    @Override
    public <T> T newObject(Class<T> persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Null 'persistentClass'");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(persistentClass);
        if (entity == null) {
            throw new IllegalArgumentException("Class is not mapped with Cayenne: " + persistentClass.getName());
        }
        return (T)this.newObject(entity.getName());
    }

    public Persistent newObject(String entityName) {
        Persistent object;
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entityName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entityName);
        }
        try {
            object = (Persistent)descriptor.createObject();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", ex);
        }
        descriptor.injectValueHolders(object);
        ObjectId id = new ObjectId(entityName);
        object.setObjectId(id);
        object.setObjectContext(this);
        object.setPersistenceState(2);
        this.getObjectStore().registerNode(id, object);
        this.getObjectStore().nodeCreated(id);
        this.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.PRE_PERSIST, object);
        return object;
    }

    public DataObject createAndRegisterNewObject(Class objectClass) {
        if (objectClass == null) {
            throw new NullPointerException("DataObject class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(objectClass);
        if (entity == null) {
            throw new IllegalArgumentException("Class is not mapped with Cayenne: " + objectClass.getName());
        }
        return this.createAndRegisterNewObject(entity.getName());
    }

    @Override
    public void registerNewObject(Object object) {
        if (object == null) {
            throw new NullPointerException("Can't register null object.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        if (entity == null) {
            throw new IllegalArgumentException("Can't find ObjEntity for Persistent class: " + object.getClass().getName() + ", class is likely not mapped.");
        }
        final Persistent persistent = (Persistent)object;
        if (persistent.getObjectId() != null) {
            if (persistent.getObjectContext() == this) {
                return;
            }
            if (persistent.getObjectContext() != null) {
                throw new IllegalStateException("Persistent is already registered with another DataContext. Try using 'localObjects()' instead.");
            }
        } else {
            persistent.setObjectId(new ObjectId(entity.getName()));
        }
        persistent.setObjectContext(this);
        persistent.setPersistenceState(2);
        this.getObjectStore().registerNode(persistent.getObjectId(), object);
        this.getObjectStore().nodeCreated(persistent.getObjectId());
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entity.getName());
        }
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitToMany(ToManyProperty property) {
                property.injectValueHolder(persistent);
                if (!property.isFault(persistent)) {
                    Object value = property.readProperty(persistent);
                    Set collection = value instanceof Map ? ((Map)value).entrySet() : (Set)value;
                    for (Object e : collection) {
                        if (!(e instanceof Persistent)) continue;
                        Persistent targetDO = (Persistent)e;
                        DataContext.this.registerNewObject(targetDO);
                        DataContext.this.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), property.getName());
                    }
                }
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                Object target = property.readPropertyDirectly(persistent);
                if (target instanceof Persistent) {
                    Persistent targetDO = (Persistent)target;
                    DataContext.this.registerNewObject(targetDO);
                    DataContext.this.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), property.getName());
                }
                return true;
            }

            public boolean visitAttribute(AttributeProperty property) {
                return true;
            }
        });
        this.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.PRE_PERSIST, persistent);
    }

    public void unregisterObjects(Collection dataObjects) {
        this.getObjectStore().objectsUnregistered(dataObjects);
    }

    public void invalidateObjects(Collection objects) {
        this.performGenericQuery(new RefreshQuery(objects));
    }

    public void deleteObjects(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        for (Persistent object : new ArrayList(objects)) {
            this.deleteObject(object);
        }
    }

    @Override
    public void deleteObject(Object object) throws DeleteDenyException {
        new DataContextDeleteAction(this).performDelete((Persistent)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject refetchObject(ObjectId oid) {
        if (oid == null) {
            throw new NullPointerException("Null ObjectId");
        }
        if (oid.isTemporary()) {
            throw new CayenneRuntimeException("Can't refetch ObjectId " + oid + ", as it is a temporary id.");
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            DataObject object = (DataObject)this.objectStore.getNode(oid);
            if (object != null) {
                this.invalidateObjects(Collections.singleton(object));
            }
        }
        DataObject object = (DataObject)DataObjectUtils.objectForQuery(this, new ObjectIdQuery(oid));
        if (object == null) {
            throw new CayenneRuntimeException("Refetch failure: no matching objects found for ObjectId " + oid);
        }
        return object;
    }

    @Override
    public void rollbackChangesLocally() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        }
    }

    @Override
    public void rollbackChanges() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            if (this.channel != null) {
                this.channel.onSync(this, diff, 3);
            }
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        } else if (this.channel != null) {
            this.channel.onSync(this, new CompoundDiff(), 3);
        }
    }

    @Override
    public void commitChangesToParent() {
        this.flushToParent(false);
    }

    @Override
    public void commitChanges() throws CayenneRuntimeException {
        this.flushToParent(true);
    }

    @Override
    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback(originatingContext);
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType);
    }

    GraphDiff onContextRollback(ObjectContext originatingContext) {
        this.rollbackChanges();
        return new CompoundDiff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        boolean childContext = this != originatingContext && changes != null;
        try {
            if (childContext) {
                this.getObjectStore().childContextSyncStarted();
                changes.apply(new ChildDiffLoader(this));
                this.fireDataChannelChanged(originatingContext, changes);
            }
            GraphDiff graphDiff = cascade ? this.flushToParent(true) : new CompoundDiff();
            return graphDiff;
        }
        finally {
            if (childContext) {
                this.getObjectStore().childContextSyncStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff flushToParent(boolean cascade) {
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Cannot commit changes - channel is not set.");
        }
        int syncType = cascade ? 2 : 1;
        ObjectStore objectStore = this.getObjectStore();
        GraphDiff parentChanges = null;
        ObjectStore objectStore2 = objectStore;
        synchronized (objectStore2) {
            boolean noop;
            ObjectStoreGraphDiff changes = objectStore.getChanges();
            boolean bl = noop = this.isValidatingObjectsOnCommit() ? changes.validateAndCheckNoop() : changes.isNoop();
            if (noop) {
                objectStore.postprocessAfterPhantomCommit();
            } else {
                try {
                    parentChanges = this.getChannel().onSync(this, changes, syncType);
                    if (objectStore.hasChanges()) {
                        objectStore.postprocessAfterCommit(parentChanges);
                    }
                    this.fireDataChannelCommitted(this, changes);
                }
                catch (CayenneRuntimeException ex) {
                    Throwable unwound = Util.unwindException(ex);
                    if (unwound instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)unwound;
                    }
                    throw new CayenneRuntimeException("Commit Exception", unwound);
                }
            }
            CompoundDiff diff = new CompoundDiff();
            diff.addAll(objectStore.getLifecycleEventInducedChanges());
            if (parentChanges != null) {
                diff.add(parentChanges);
            }
            if (!diff.isNoop()) {
                this.fireDataChannelCommitted(this.getChannel(), diff);
            }
            return diff;
        }
    }

    public ResultIterator performIteratedQuery(Query query) throws CayenneException {
        ResultIterator result;
        if (Transaction.getThreadTransaction() != null) {
            return this.internalPerformIteratedQuery(query);
        }
        Transaction tx = this.getParentDataDomain().createTransaction();
        Transaction.bindThreadTransaction(tx);
        try {
            result = this.internalPerformIteratedQuery(query);
        }
        catch (Exception e) {
            Transaction.bindThreadTransaction(null);
            tx.setRollbackOnly();
            throw new CayenneException(e);
        }
        finally {
            if (tx.getStatus() == 7) {
                try {
                    tx.rollback();
                }
                catch (Exception rollbackEx) {}
            }
        }
        return new TransactionResultIteratorDecorator(result, tx);
    }

    ResultIterator internalPerformIteratedQuery(Query query) throws CayenneException {
        IteratedSelectObserver observer = new IteratedSelectObserver();
        this.getParentDataDomain().performQueries(Collections.singletonList(query), observer);
        return observer.getResultIterator();
    }

    @Override
    public QueryResponse performGenericQuery(Query query) {
        query = this.nonNullDelegate().willPerformGenericQuery(this, query);
        if (query == null) {
            return new GenericResponse();
        }
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Can't run query - parent DataChannel is not set.");
        }
        return this.onQuery(this, query);
    }

    @Override
    public List performQuery(Query query) {
        query = this.nonNullDelegate().willPerformQuery(this, query);
        if (query == null) {
            return new ArrayList(1);
        }
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    @Override
    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new DataContextQueryAction(this, context, query).execute();
    }

    public int[] performNonSelectingQuery(Query query) {
        int[] count = this.performGenericQuery(query).firstUpdateCount();
        return count != null ? count : new int[]{};
    }

    public int[] performNonSelectingQuery(String queryName) {
        return this.performNonSelectingQuery(new NamedQuery(queryName));
    }

    public int[] performNonSelectingQuery(String queryName, Map<String, ?> parameters) {
        return this.performNonSelectingQuery(new NamedQuery(queryName, parameters));
    }

    public List<?> performQuery(String queryName, boolean expireCachedLists) {
        return this.performQuery(queryName, Collections.EMPTY_MAP, expireCachedLists);
    }

    public List<?> performQuery(String queryName, Map parameters, boolean expireCachedLists) {
        NamedQuery query = new NamedQuery(queryName, parameters);
        query.setForceNoCache(expireCachedLists);
        return this.performQuery(query);
    }

    @Override
    public EntityResolver getEntityResolver() {
        this.awakeFromDeserialization();
        return this.entityResolver;
    }

    public boolean isUsingSharedSnapshotCache() {
        return this.usingSharedSnaphsotCache;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.channel == null && this.lazyInitParentDomainName != null) {
            out.writeObject(this.lazyInitParentDomainName);
        } else if (this.channel instanceof DataDomain) {
            DataDomain domain = (DataDomain)this.channel;
            out.writeObject(domain.getName());
        } else {
            out.writeObject(this.channel);
        }
        if (!this.isUsingSharedSnapshotCache()) {
            out.writeObject(this.objectStore.getDataRowCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object value = in.readObject();
        if (value instanceof DataChannel) {
            this.channel = (DataChannel)value;
        } else if (value instanceof String) {
            this.lazyInitParentDomainName = (String)value;
        } else {
            throw new CayenneRuntimeException("Parent attribute of DataContext was neither a QueryEngine nor the name of a valid DataDomain:" + value);
        }
        if (!this.isUsingSharedSnapshotCache()) {
            DataRowStore cache = (DataRowStore)in.readObject();
            this.objectStore.setDataRowCache(cache);
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            Iterator it = this.objectStore.getObjectIterator();
            while (it.hasNext()) {
                Persistent object = (Persistent)it.next();
                object.setObjectContext(this);
            }
        }
    }

    private final void awakeFromDeserialization() {
        if (this.channel == null && this.lazyInitParentDomainName != null) {
            this.setChannel(Configuration.getSharedConfiguration().getDomain(this.lazyInitParentDomainName));
        }
    }

    @Override
    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    @Override
    public GraphManager getGraphManager() {
        return this.objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent localObject(ObjectId id, Object prototype) {
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
            if (cachedObject != null) {
                int state = cachedObject.getPersistenceState();
                if (cachedObject != prototype && state != 4 && state != 6) {
                    descriptor.injectValueHolders(cachedObject);
                    if (prototype != null && ((Persistent)prototype).getPersistenceState() != 5) {
                        descriptor.shallowMerge(prototype, cachedObject);
                        if (state == 5) {
                            cachedObject.setPersistenceState(3);
                        }
                    }
                }
                return cachedObject;
            }
            Persistent localObject = (Persistent)descriptor.createObject();
            localObject.setObjectContext(this);
            localObject.setObjectId(id);
            this.getGraphManager().registerNode(id, localObject);
            if (prototype != null && ((Persistent)prototype).getPersistenceState() != 5) {
                localObject.setPersistenceState(3);
                descriptor.injectValueHolders(localObject);
                descriptor.shallowMerge(prototype, localObject);
            } else {
                localObject.setPersistenceState(5);
            }
            return localObject;
        }
    }
}

