/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.query.SQLTemplateMetadata;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLTemplate
extends AbstractQuery
implements ParameterizedQuery,
XMLSerializable {
    static final String COLUMN_NAME_CAPITALIZATION_PROPERTY = "cayenne.SQLTemplate.columnNameCapitalization";
    public static final String UPPERCASE_COLUMN_NAMES = "upper";
    public static final String LOWERCASE_COLUMN_NAMES = "lower";
    private static final Transformer nullMapTransformer = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input : Collections.EMPTY_MAP;
        }
    };
    protected String defaultTemplate;
    protected Map<String, String> templates;
    protected Map<String, ?>[] parameters;
    protected String columnNamesCapitalization;
    SQLTemplateMetadata selectInfo = new SQLTemplateMetadata();

    public SQLTemplate() {
    }

    public SQLTemplate(DataMap rootMap, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootMap);
    }

    public SQLTemplate(ObjEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(Class<?> rootClass, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootClass);
    }

    public SQLTemplate(DbEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(String objEntityName, String defaultTemplate) {
        this.setRoot(objEntityName);
        this.setDefaultTemplate(defaultTemplate);
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.selectInfo.resolve(this.root, resolver, this);
        return this.selectInfo;
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.sqlAction(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.apache.cayenne.map.SQLTemplateBuilder");
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        } else if (this.root instanceof DataMap) {
            rootType = "data-map";
            rootString = ((DataMap)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.selectInfo.encodeAsXML(encoder);
        if (this.getColumnNamesCapitalization() != null) {
            encoder.printProperty(COLUMN_NAME_CAPITALIZATION_PROPERTY, this.getColumnNamesCapitalization());
        }
        if (this.defaultTemplate != null) {
            encoder.print("<sql><![CDATA[");
            encoder.print(this.defaultTemplate);
            encoder.println("]]></sql>");
        }
        if (this.templates != null && !this.templates.isEmpty()) {
            for (Map.Entry<String, String> entry : this.templates.entrySet()) {
                String sql;
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null || (sql = value.trim()).length() <= 0) continue;
                encoder.print("<sql adapter-class=\"");
                encoder.print(key);
                encoder.print("\"><![CDATA[");
                encoder.print(sql);
                encoder.println("]]></sql>");
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public void initWithProperties(Map<String, ?> properties) {
        Object columnNamesCapitalization;
        this.selectInfo.initWithProperties(properties);
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        this.columnNamesCapitalization = (columnNamesCapitalization = properties.get(COLUMN_NAME_CAPITALIZATION_PROPERTY)) != null ? columnNamesCapitalization.toString() : null;
    }

    public Iterator<?> parametersIterator() {
        return this.parameters == null || this.parameters.length == 0 ? IteratorUtils.emptyIterator() : IteratorUtils.transformedIterator((Iterator)IteratorUtils.arrayIterator((Object[])this.parameters), (Transformer)nullMapTransformer);
    }

    public int parametersSize() {
        return this.parameters != null ? this.parameters.length : 0;
    }

    public SQLTemplate queryWithParameters(Map<String, ?> parameters) {
        return this.queryWithParameters(new Map[]{parameters});
    }

    public SQLTemplate queryWithParameters(Map<String, ?>[] parameters) {
        SQLTemplate query = new SQLTemplate();
        query.setRoot(this.root);
        query.setDefaultTemplate(this.getDefaultTemplate());
        if (this.templates != null) {
            query.templates = new HashMap<String, String>(this.templates);
        }
        query.selectInfo.copyFromInfo(this.selectInfo);
        query.setParameters(parameters);
        if (!Util.isEmptyString(this.name)) {
            StringBuilder buffer = new StringBuilder(this.name);
            if (parameters != null) {
                for (Map<String, ?> parameter : parameters) {
                    if (parameter.isEmpty()) continue;
                    buffer.append(((Object)parameter).hashCode());
                }
            }
            query.setName(buffer.toString());
        }
        return query;
    }

    @Override
    public Query createQuery(Map<String, ?> parameters) {
        return this.queryWithParameters(parameters);
    }

    public String getCachePolicy() {
        return this.selectInfo.getCachePolicy();
    }

    public void setCachePolicy(String policy) {
        this.selectInfo.setCachePolicy(policy);
    }

    public String[] getCacheGroups() {
        return this.selectInfo.getCacheGroups();
    }

    public void setCacheGroups(String[] cachGroups) {
        this.selectInfo.setCacheGroups(cachGroups);
    }

    public int getFetchLimit() {
        return this.selectInfo.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.selectInfo.setFetchLimit(fetchLimit);
    }

    public int getPageSize() {
        return this.selectInfo.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.selectInfo.setPageSize(pageSize);
    }

    public void setFetchingDataRows(boolean flag) {
        this.selectInfo.setFetchingDataRows(flag);
    }

    public boolean isFetchingDataRows() {
        return this.selectInfo.isFetchingDataRows();
    }

    public boolean isRefreshingObjects() {
        return this.selectInfo.isRefreshingObjects();
    }

    public void setRefreshingObjects(boolean flag) {
        this.selectInfo.setRefreshingObjects(flag);
    }

    public boolean isResolvingInherited() {
        return this.selectInfo.isResolvingInherited();
    }

    public void setResolvingInherited(boolean b) {
        this.selectInfo.setResolvingInherited(b);
    }

    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(String string) {
        this.defaultTemplate = string;
    }

    public synchronized String getTemplate(String key) {
        if (this.templates == null) {
            return this.defaultTemplate;
        }
        String template = this.templates.get(key);
        return template != null ? template : this.defaultTemplate;
    }

    public synchronized String getCustomTemplate(String key) {
        return this.templates != null ? this.templates.get(key) : null;
    }

    public synchronized void setTemplate(String key, String template) {
        if (this.templates == null) {
            this.templates = new HashMap<String, String>();
        }
        this.templates.put(key, template);
    }

    public synchronized void removeTemplate(String key) {
        if (this.templates != null) {
            this.templates.remove(key);
        }
    }

    public synchronized Collection<String> getTemplateKeys() {
        return this.templates != null ? Collections.unmodifiableCollection(this.templates.keySet()) : Collections.EMPTY_LIST;
    }

    public Map<String, ?> getParameters() {
        Map<String, ?> map = this.parameters != null && this.parameters.length > 0 ? this.parameters[0] : null;
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public void setParameters(Map<String, ?> map) {
        Map[] mapArray;
        if (map != null) {
            Map[] mapArray2 = new Map[1];
            mapArray = mapArray2;
            mapArray2[0] = map;
        } else {
            mapArray = null;
        }
        this.setParameters(mapArray);
    }

    public void setParameters(Map<String, ?>[] parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new Map[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameters[i] = parameters[i] != null ? new HashMap(parameters[i]) : new HashMap();
            }
        }
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.selectInfo.getPrefetchTree();
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.selectInfo.addPrefetch(prefetchPath, 1);
    }

    public void removePrefetch(String prefetch) {
        this.selectInfo.removePrefetch(prefetch);
    }

    public void addPrefetches(Collection<String> prefetches) {
        this.selectInfo.addPrefetches(prefetches, 1);
    }

    public void clearPrefetches() {
        this.selectInfo.clearPrefetches();
    }

    public String getColumnNamesCapitalization() {
        return this.columnNamesCapitalization;
    }

    public void setColumnNamesCapitalization(String columnNameCapitalization) {
        this.columnNamesCapitalization = columnNameCapitalization;
    }

    public void setResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.selectInfo.setResultSetMapping(resultSetMapping);
    }
}

