/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.QueryMetadata;

class ProcedureQueryMetadata
extends BaseQueryMetadata {
    transient Procedure procedure;

    ProcedureQueryMetadata() {
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    void copyFromInfo(QueryMetadata info) {
        this.procedure = null;
        super.copyFromInfo(info);
    }

    void resolve(Object root, Object resultRoot, EntityResolver resolver, ProcedureQuery query) {
        if (super.resolve(resultRoot, resolver, null)) {
            this.procedure = null;
            if (root != null) {
                if (root instanceof String) {
                    this.procedure = resolver.lookupProcedure((String)root);
                } else if (root instanceof Procedure) {
                    this.procedure = (Procedure)root;
                }
                if (this.procedure != null && this.dataMap == null) {
                    this.dataMap = this.procedure.getDataMap();
                }
            }
            if (!"nocache".equals(this.getCachePolicy())) {
                if (query.getName() != null) {
                    this.cacheKey = query.getName();
                } else {
                    Map<String, ?> parameters;
                    StringBuilder key = new StringBuilder("proc:");
                    if (this.procedure != null) {
                        key.append(this.procedure.getName());
                    }
                    if (!(parameters = query.getParameters()).isEmpty()) {
                        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
                        Collections.sort(keys);
                        for (String parameterKey : keys) {
                            key.append('/').append(parameterKey).append('=').append(parameters.get(parameterKey));
                        }
                    }
                    this.cacheKey = key.toString();
                }
            }
        }
    }
}

