/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conf.RuntimeLoadDelegate;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.ApplicationProjectFile;
import org.apache.cayenne.project.ApplicationUpgradeHandler;
import org.apache.cayenne.project.DataMapFile;
import org.apache.cayenne.project.DataNodeFile;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectConfiguration;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.project.ProjectFile;

public class ApplicationProject
extends Project {
    protected Configuration configuration;

    public ApplicationProject(File projectFile) {
        this(projectFile, null);
    }

    public ApplicationProject(File projectFile, Configuration configuration) {
        if (configuration == null) {
            if (projectFile != null) {
                if (projectFile.isDirectory()) {
                    projectFile = new File(projectFile.getPath() + File.separator + "cayenne.xml");
                }
                try {
                    projectFile = projectFile.getCanonicalFile();
                }
                catch (IOException e) {
                    throw new ProjectException("Bad project file: " + projectFile);
                }
            }
            configuration = new ProjectConfiguration(projectFile);
            configuration.setLoaderDelegate(new ProjectLoader(configuration));
        }
        this.configuration = configuration;
        this.initialize(projectFile);
        this.postInitialize(projectFile);
    }

    public void upgrade() throws ProjectException {
        ApplicationUpgradeHandler.sharedHandler().performUpgrade(this);
    }

    protected void postInitialize(File projectFile) {
        this.loadProject();
        super.postInitialize(projectFile);
    }

    protected void loadProject() {
        if (this.configuration.canInitialize()) {
            try {
                this.configuration.initialize();
            }
            catch (Exception e) {
                throw new ProjectException("Error initializaing project configuration.", e);
            }
            this.configuration.didInitialize();
        }
        if (this.configuration.getProjectVersion() == null) {
            this.configuration.setProjectVersion(ApplicationUpgradeHandler.sharedHandler().supportedVersion());
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ProjectConfiguration config) {
        this.configuration = config;
    }

    public void checkForUpgrades() {
        this.upgradeStatus = ApplicationUpgradeHandler.sharedHandler().checkForUpgrades(this.configuration, this.upgradeMessages);
    }

    public List getChildren() {
        return new ArrayList<DataDomain>(this.getConfiguration().getDomains());
    }

    public ProjectFile projectFileForObject(Object obj) {
        if (this.requiresProjectFile(obj)) {
            String domainFileName = this.getConfiguration().getDomainConfigurationName();
            ApplicationProjectFile file = new ApplicationProjectFile(this, domainFileName);
            file.setSaveDelegate(this.configuration.getSaverDelegate());
            return file;
        }
        if (this.requiresMapFile(obj)) {
            return new DataMapFile((Project)this, (DataMap)obj);
        }
        if (this.requiresNodeFile(obj)) {
            return new DataNodeFile((Project)this, (DataNode)obj);
        }
        return null;
    }

    protected boolean requiresProjectFile(Object obj) {
        return obj == this;
    }

    protected boolean requiresMapFile(Object obj) {
        return obj instanceof DataMap;
    }

    protected boolean requiresNodeFile(Object obj) {
        if (obj instanceof DataNode) {
            DataNode node = (DataNode)obj;
            if (DriverDataSourceFactory.class.getName().equals(node.getDataSourceFactory())) {
                return true;
            }
        }
        return false;
    }

    public ConfigStatus getLoadStatus() {
        return this.configuration != null ? this.configuration.getLoadStatus() : new ConfigStatus();
    }

    final class ProjectLoader
    extends RuntimeLoadDelegate {
        public ProjectLoader(Configuration config) {
            super(config, config.getLoadStatus());
        }

        protected void updateDefaults(DataDomain domain) {
        }

        public void shouldLoadDataDomain(String domainName) {
            super.shouldLoadDataDomain(domainName);
            try {
                this.findDomain(domainName).getEntityResolver().setIndexedByClass(false);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Domain is not loaded: " + domainName);
            }
        }

        public void shouldLoadDataDomainProperties(String domainName, Map properties) {
            HashMap propertiesClone = new HashMap(properties);
            Object dataContextFactory = propertiesClone.remove("cayenne.DataDomain.dataContextFactory");
            super.shouldLoadDataDomainProperties(domainName, propertiesClone);
            if (dataContextFactory != null) {
                try {
                    this.findDomain(domainName).getProperties().put("cayenne.DataDomain.dataContextFactory", dataContextFactory);
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Domain is not loaded: " + domainName);
                }
            }
        }
    }
}

