/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropRelationshipToModel
extends AbstractToModelToken {
    private DbEntity entity;
    private DbRelationship rel;

    public DropRelationshipToModel(DbEntity entity, DbRelationship rel) {
        this.entity = entity;
        this.rel = rel;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddRelationshipToDb(this.entity, this.rel);
    }

    public void execute(MergerContext mergerContext) {
        this.remove(this.rel, true);
    }

    private void remove(DbRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            this.remove(rel.getReverseRelationship(), false);
        }
        DbEntity dbEntity = (DbEntity)rel.getSourceEntity();
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(dbEntity)) {
            this.remove(objEntity.getRelationshipForDbRelationship(rel), true);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
    }

    private void remove(ObjRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            this.remove(rel.getReverseRelationship(), false);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
    }

    public String getTokenName() {
        return "Drop Relationship";
    }

    public String getTokenValue() {
        StringBuilder s = new StringBuilder();
        s.append(this.rel.getSourceEntity().getName());
        s.append("->");
        s.append(this.rel.getTargetEntityName());
        return s.toString();
    }
}

