/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropColumnToModel
extends AbstractToModelToken {
    private DbEntity entity;
    private DbAttribute column;

    public DropColumnToModel(DbEntity entity, DbAttribute column) {
        this.entity = entity;
        this.column = column;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddColumnToDb(this.entity, this.column);
    }

    public void execute(MergerContext mergerContext) {
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(this.entity)) {
            ObjAttribute objAttribute = objEntity.getAttributeForDbAttribute(this.column);
            if (objAttribute == null) continue;
            objEntity.removeAttribute(objAttribute.getName());
        }
        this.entity.removeAttribute(this.column.getName());
    }

    public String getTokenName() {
        return "Drop Column";
    }

    public String getTokenValue() {
        return this.entity.getName() + "." + this.column.getName();
    }
}

