/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.InheritanceType;
import org.apache.cayenne.jpa.map.JpaAbstractEntity;
import org.apache.cayenne.jpa.map.JpaAssociationOverride;
import org.apache.cayenne.jpa.map.JpaAttributeOverride;
import org.apache.cayenne.jpa.map.JpaDiscriminatorColumn;
import org.apache.cayenne.jpa.map.JpaInheritance;
import org.apache.cayenne.jpa.map.JpaNamedNativeQuery;
import org.apache.cayenne.jpa.map.JpaNamedQuery;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaSecondaryTable;
import org.apache.cayenne.jpa.map.JpaSequenceGenerator;
import org.apache.cayenne.jpa.map.JpaSqlResultSetMapping;
import org.apache.cayenne.jpa.map.JpaTable;
import org.apache.cayenne.jpa.map.JpaTableGenerator;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaEntity
extends JpaAbstractEntity
implements XMLSerializable {
    protected String name;
    protected JpaTable table;
    protected JpaInheritance inheritance;
    protected String discriminatorValue;
    protected JpaDiscriminatorColumn discriminatorColumn;
    protected JpaSequenceGenerator sequenceGenerator;
    protected JpaTableGenerator tableGenerator;
    protected JpaSqlResultSetMapping sqlResultSetMapping;
    protected Collection<JpaAttributeOverride> attributeOverrides;
    protected Collection<JpaAssociationOverride> associationOverrides;
    protected JpaEntity superEntity;
    protected Collection<JpaNamedQuery> namedQueries;
    protected Collection<JpaNamedNativeQuery> namedNativeQueries;
    protected Collection<JpaSecondaryTable> secondaryTables;
    protected Collection<JpaPrimaryKeyJoinColumn> primaryKeyJoinColumns;

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<entity");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.className != null) {
            encoder.print(" class=\"" + this.className + "\"");
        }
        if (this.access != null) {
            encoder.print(" access=\"" + this.access.name() + "\"");
        }
        encoder.print(" metadata-complete=\"" + this.metadataComplete + "\"");
        encoder.println('>');
        encoder.indent(1);
        if (this.description != null) {
            encoder.println("<description>" + this.description + "</description>");
        }
        if (this.table != null) {
            this.table.encodeAsXML(encoder);
        }
        if (this.secondaryTables != null) {
            encoder.print(this.secondaryTables);
        }
        if (this.primaryKeyJoinColumns != null) {
            encoder.print(this.primaryKeyJoinColumns);
        }
        if (this.idClass != null) {
            this.idClass.encodeAsXML(encoder);
        }
        if (this.inheritance != null) {
            this.inheritance.encodeAsXML(encoder);
        }
        if (this.discriminatorValue != null) {
            encoder.println("<discriminator-value>" + this.discriminatorValue + "</discriminator-value>");
        }
        if (this.discriminatorColumn != null) {
            this.discriminatorColumn.encodeAsXML(encoder);
        }
        if (this.sequenceGenerator != null) {
            this.sequenceGenerator.encodeAsXML(encoder);
        }
        if (this.tableGenerator != null) {
            this.tableGenerator.encodeAsXML(encoder);
        }
        if (this.namedQueries != null) {
            encoder.print(this.namedQueries);
        }
        if (this.namedNativeQueries != null) {
            encoder.print(this.namedNativeQueries);
        }
        if (this.sqlResultSetMapping != null) {
            this.sqlResultSetMapping.encodeAsXML(encoder);
        }
        if (this.excludeDefaultListeners) {
            encoder.println("<exclude-default-listeners/>");
        }
        if (this.excludeSuperclassListeners) {
            encoder.println("<exclude-superclass-listeners/>");
        }
        if (this.entityListeners != null) {
            this.entityListeners.encodeAsXML(encoder);
        }
        if (this.prePersist != null) {
            this.prePersist.encodeAsXML(encoder);
        }
        if (this.postPersist != null) {
            this.postPersist.encodeAsXML(encoder);
        }
        if (this.preRemove != null) {
            this.preRemove.encodeAsXML(encoder);
        }
        if (this.postRemove != null) {
            this.postRemove.encodeAsXML(encoder);
        }
        if (this.preUpdate != null) {
            this.preUpdate.encodeAsXML(encoder);
        }
        if (this.postUpdate != null) {
            this.postUpdate.encodeAsXML(encoder);
        }
        if (this.postLoad != null) {
            this.postLoad.encodeAsXML(encoder);
        }
        if (this.attributeOverrides != null) {
            encoder.print(this.attributeOverrides);
        }
        if (this.associationOverrides != null) {
            encoder.print(this.associationOverrides);
        }
        if (this.attributes != null) {
            this.attributes.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</entity>");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @TreeNodeChild
    public JpaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(JpaDiscriminatorColumn discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    @TreeNodeChild
    public JpaInheritance getInheritance() {
        return this.inheritance;
    }

    public InheritanceType lookupInheritanceStrategy() {
        if (this.inheritance != null) {
            return this.inheritance.getStrategy();
        }
        if (this.superEntity != null) {
            return this.superEntity.lookupInheritanceStrategy();
        }
        return null;
    }

    public JpaTable lookupTable() {
        if (this.table != null) {
            return this.table;
        }
        if (this.superEntity != null) {
            return this.superEntity.lookupTable();
        }
        return null;
    }

    public JpaDiscriminatorColumn lookupDiscriminatorColumn() {
        if (this.discriminatorColumn != null) {
            return this.discriminatorColumn;
        }
        if (this.superEntity != null) {
            return this.superEntity.lookupDiscriminatorColumn();
        }
        return null;
    }

    public void setInheritance(JpaInheritance inheritance) {
        this.inheritance = inheritance;
    }

    @TreeNodeChild
    public JpaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public void setSequenceGenerator(JpaSequenceGenerator sequenceGenerator) {
        this.sequenceGenerator = sequenceGenerator;
    }

    @TreeNodeChild
    public JpaSqlResultSetMapping getSqlResultSetMapping() {
        return this.sqlResultSetMapping;
    }

    public void setSqlResultSetMapping(JpaSqlResultSetMapping sqlResultSetMapping) {
        this.sqlResultSetMapping = sqlResultSetMapping;
    }

    @TreeNodeChild
    public JpaTable getTable() {
        return this.table;
    }

    public void setTable(JpaTable table) {
        this.table = table;
    }

    @TreeNodeChild
    public JpaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    public void setTableGenerator(JpaTableGenerator tableGenerator) {
        this.tableGenerator = tableGenerator;
    }

    @TreeNodeChild(type=JpaAttributeOverride.class)
    public Collection<JpaAttributeOverride> getAttributeOverrides() {
        if (this.attributeOverrides == null) {
            this.attributeOverrides = new ArrayList<JpaAttributeOverride>();
        }
        return this.attributeOverrides;
    }

    @TreeNodeChild(type=JpaAssociationOverride.class)
    public Collection<JpaAssociationOverride> getAssociationOverrides() {
        if (this.associationOverrides == null) {
            this.associationOverrides = new ArrayList<JpaAssociationOverride>();
        }
        return this.associationOverrides;
    }

    @TreeNodeChild(type=JpaNamedNativeQuery.class)
    public Collection<JpaNamedNativeQuery> getNamedNativeQueries() {
        if (this.namedNativeQueries == null) {
            this.namedNativeQueries = new ArrayList<JpaNamedNativeQuery>();
        }
        return this.namedNativeQueries;
    }

    @TreeNodeChild(type=JpaNamedQuery.class)
    public Collection<JpaNamedQuery> getNamedQueries() {
        if (this.namedQueries == null) {
            this.namedQueries = new ArrayList<JpaNamedQuery>();
        }
        return this.namedQueries;
    }

    @TreeNodeChild(type=JpaPrimaryKeyJoinColumn.class)
    public Collection<JpaPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        if (this.primaryKeyJoinColumns == null) {
            this.primaryKeyJoinColumns = new ArrayList<JpaPrimaryKeyJoinColumn>();
        }
        return this.primaryKeyJoinColumns;
    }

    @TreeNodeChild(type=JpaSecondaryTable.class)
    public Collection<JpaSecondaryTable> getSecondaryTables() {
        if (this.secondaryTables == null) {
            this.secondaryTables = new ArrayList<JpaSecondaryTable>();
        }
        return this.secondaryTables;
    }

    public JpaSecondaryTable getSecondaryTable(String name) {
        if (this.secondaryTables != null) {
            for (JpaSecondaryTable table : this.secondaryTables) {
                if (!name.equals(table.getName())) continue;
                return table;
            }
        }
        return null;
    }

    public String toString() {
        return "JpaEntity:" + this.name;
    }

    public JpaEntity getSuperEntity() {
        return this.superEntity;
    }

    public void setSuperEntity(JpaEntity superEntity) {
        this.superEntity = superEntity;
    }
}

