/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.DefaultType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.oracle.OracleActionBuilder;
import org.apache.cayenne.dba.oracle.OracleEJBQLTranslatorFactory;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.dba.oracle.OracleUtilDateType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.UpdateBatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleAdapter
extends JdbcAdapter {
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String TRIM_FUNCTION = "RTRIM";
    public static final String NEW_CLOB_FUNCTION = "EMPTY_CLOB()";
    public static final String NEW_BLOB_FUNCTION = "EMPTY_BLOB()";
    protected static boolean initDone;
    protected static int oracleCursorType;
    protected static Method outputStreamFromBlobMethod;
    protected static Method writerFromClobMethod;
    protected static boolean supportsOracleLOB;

    protected static void initDriverInformation() {
        initDone = true;
        try {
            Class<?> oraTypes = Class.forName("oracle.jdbc.driver.OracleTypes");
            Field cursorField = oraTypes.getField("CURSOR");
            oracleCursorType = cursorField.getInt(null);
            outputStreamFromBlobMethod = Class.forName("oracle.sql.BLOB").getMethod("getBinaryOutputStream", new Class[0]);
            writerFromClobMethod = Class.forName("oracle.sql.CLOB").getMethod("getCharacterOutputStream", new Class[0]);
            supportsOracleLOB = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Method getOutputStreamFromBlobMethod() {
        return outputStreamFromBlobMethod;
    }

    public static boolean isSupportsOracleLOB() {
        return supportsOracleLOB;
    }

    static boolean updatesLOBColumns(BatchQuery query) {
        boolean isInsert = query instanceof InsertBatchQuery;
        boolean isUpdate = query instanceof UpdateBatchQuery;
        if (!isInsert && !isUpdate) {
            return false;
        }
        List<DbAttribute> updatedAttributes = isInsert ? query.getDbAttributes() : ((UpdateBatchQuery)query).getUpdatedAttributes();
        for (DbAttribute attr : updatedAttributes) {
            int type = attr.getType();
            if (type != 2005 && type != 2004) continue;
            return true;
        }
        return false;
    }

    public static Method getWriterFromClobMethod() {
        return writerFromClobMethod;
    }

    public static int getOracleCursorType() {
        if (oracleCursorType == Integer.MAX_VALUE) {
            throw new CayenneRuntimeException("No information exists about oracle types. Check that Oracle JDBC driver is available to the application.");
        }
        return oracleCursorType;
    }

    public OracleAdapter() {
        this.setSupportsBatchUpdates(true);
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new OracleEJBQLTranslatorFactory();
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new ByteArrayType(true, true));
        map.registerType(new OracleUtilDateType());
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
        map.registerType(new OracleIntegerType());
        map.registerType(new OracleDoubleType());
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new OraclePkGenerator();
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + table.getFullyQualifiedName() + " CASCADE CONSTRAINTS");
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        DbAttribute attr = super.buildAttribute(name, typeName, type, size, scale, allowNulls);
        if (type == 3 && scale <= 0) {
            attr.setType(4);
            attr.setScale(-1);
        } else if (type == 1111) {
            if (ORACLE_FLOAT.equals(typeName)) {
                attr.setType(6);
            } else if (ORACLE_BLOB.equals(typeName)) {
                attr.setType(2004);
            } else if (ORACLE_CLOB.equals(typeName)) {
                attr.setType(2005);
            }
        } else if (type == 91 && "DATE".equals(typeName)) {
            attr.setType(93);
        }
        return attr;
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new OracleActionBuilder(this, node.getEntityResolver()));
    }

    static {
        oracleCursorType = Integer.MAX_VALUE;
        OracleAdapter.initDriverInformation();
    }

    final class OracleDoubleType
    extends DefaultType {
        public OracleDoubleType() {
            super(Double.class.getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setDouble(pos, ((Number)val).doubleValue());
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }

    final class OracleIntegerType
    extends DefaultType {
        public OracleIntegerType() {
            super(Integer.class.getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setInt(pos, ((Number)val).intValue());
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }
}

