/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.dba.LongPkRange;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.IDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPkGenerator
implements PkGenerator {
    public static final int DEFAULT_PK_CACHE_SIZE = 20;
    protected Map<String, LongPkRange> pkCache = new HashMap<String, LongPkRange>();
    protected int pkCacheSize = 20;

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        if (!this.autoPkTableExists(node)) {
            this.runUpdate(node, this.pkTableCreateString());
        }
        this.runUpdate(node, this.pkDeleteString(dbEntities));
        for (DbEntity ent : dbEntities) {
            this.runUpdate(node, this.pkCreateString(ent.getName()));
        }
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size() + 2);
        list.add(this.pkTableCreateString());
        list.add(this.pkDeleteString(dbEntities));
        for (DbEntity ent : dbEntities) {
            list.add(this.pkCreateString(ent.getName()));
        }
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        if (this.autoPkTableExists(node)) {
            this.runUpdate(node, this.dropAutoPkString());
        }
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(this.dropAutoPkString());
        return list;
    }

    protected String pkTableCreateString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE AUTO_PK_SUPPORT (").append("  TABLE_NAME CHAR(100) NOT NULL,").append("  NEXT_ID BIGINT NOT NULL,").append("  PRIMARY KEY(TABLE_NAME)").append(")");
        return buf.toString();
    }

    protected String pkDeleteString(List<DbEntity> dbEntities) {
        StringBuffer buf = new StringBuffer();
        buf.append("DELETE FROM AUTO_PK_SUPPORT WHERE TABLE_NAME IN (");
        int len = dbEntities.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            DbEntity ent = dbEntities.get(i);
            buf.append('\'').append(ent.getName()).append('\'');
        }
        buf.append(')');
        return buf.toString();
    }

    protected String pkCreateString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("INSERT INTO AUTO_PK_SUPPORT").append(" (TABLE_NAME, NEXT_ID)").append(" VALUES ('").append(entName).append("', 200)");
        return buf.toString();
    }

    protected String pkSelectString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '").append(entName).append('\'');
        return buf.toString();
    }

    protected String pkUpdateString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("UPDATE AUTO_PK_SUPPORT").append(" SET NEXT_ID = NEXT_ID + ").append(this.pkCacheSize).append(" WHERE TABLE_NAME = '").append(entName).append('\'');
        return buf.toString();
    }

    protected String dropAutoPkString() {
        return "DROP TABLE AUTO_PK_SUPPORT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean autoPkTableExists(DataNode node) throws SQLException {
        Connection con = node.getDataSource().getConnection();
        boolean exists = false;
        try {
            DatabaseMetaData md = con.getMetaData();
            ResultSet tables = md.getTables(null, null, "AUTO_PK_SUPPORT", null);
            try {
                exists = tables.next();
            }
            finally {
                tables.close();
            }
        }
        finally {
            con.close();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runUpdate(DataNode node, String sql) throws SQLException {
        QueryLogger.logQuery(sql, Collections.EMPTY_LIST);
        Connection con = node.getDataSource().getConnection();
        try {
            int n;
            Statement upd = con.createStatement();
            try {
                n = upd.executeUpdate(sql);
            }
            catch (Throwable throwable) {
                upd.close();
                throw throwable;
            }
            upd.close();
            return n;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generatePk(DataNode node, DbAttribute pk) throws Exception {
        long value;
        DbEntity entity = (DbEntity)pk.getEntity();
        switch (pk.getType()) {
            case -3: 
            case -2: {
                return IDUtil.pseudoUniqueSecureByteSequence(pk.getMaxLength());
            }
        }
        DbKeyGenerator pkGenerator = entity.getPrimaryKeyGenerator();
        long cacheSize = pkGenerator != null && pkGenerator.getKeyCacheSize() != null ? (long)pkGenerator.getKeyCacheSize().intValue() : (long)this.pkCacheSize;
        if (cacheSize <= 1L) {
            value = this.longPkFromDatabase(node, entity);
        } else {
            Map<String, LongPkRange> map = this.pkCache;
            synchronized (map) {
                LongPkRange r = this.pkCache.get(entity.getName());
                if (r == null) {
                    r = new LongPkRange(1L, 0L);
                    this.pkCache.put(entity.getName(), r);
                }
                if (r.isExhausted()) {
                    long val = this.longPkFromDatabase(node, entity);
                    r.reset(val, val + cacheSize - 1L);
                }
                value = r.getNextPrimaryKey();
            }
        }
        if (pk.getType() == -5) {
            return value;
        }
        return (int)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generatePkForDbEntity(DataNode node, DbEntity ent) throws Exception {
        byte[] binPK = this.binaryPK(ent);
        if (binPK != null) {
            return binPK;
        }
        DbKeyGenerator pkGenerator = ent.getPrimaryKeyGenerator();
        int cacheSize = pkGenerator != null && pkGenerator.getKeyCacheSize() != null ? pkGenerator.getKeyCacheSize() : this.pkCacheSize;
        if (cacheSize <= 1) {
            return this.pkFromDatabase(node, ent);
        }
        Map<String, LongPkRange> map = this.pkCache;
        synchronized (map) {
            LongPkRange r = this.pkCache.get(ent.getName());
            if (r == null) {
                r = new LongPkRange(1L, 0L);
                this.pkCache.put(ent.getName(), r);
            }
            if (r.isExhausted()) {
                int val = this.pkFromDatabase(node, ent);
                r.reset(val, val + cacheSize - 1);
            }
            return r.getNextPrimaryKey();
        }
    }

    protected byte[] binaryPK(DbEntity entity) {
        DbAttribute pk;
        Collection<DbAttribute> pkColumns = entity.getPrimaryKeys();
        if (pkColumns.size() == 1 && (pk = pkColumns.iterator().next()).getMaxLength() > 0 && (pk.getType() == -2 || pk.getType() == -3)) {
            return IDUtil.pseudoUniqueSecureByteSequence(pk.getMaxLength());
        }
        return null;
    }

    protected int pkFromDatabase(DataNode node, DbEntity ent) throws Exception {
        String select = "SELECT #result('NEXT_ID' 'int' 'NEXT_ID') FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '" + ent.getName() + '\'';
        ArrayList<Query> queries = new ArrayList<Query>(2);
        queries.add(new SQLTemplate(ent, select));
        queries.add(new SQLTemplate(ent, this.pkUpdateString(ent.getName())));
        PkRetrieveProcessor observer = new PkRetrieveProcessor(ent.getName());
        node.performQueries(queries, observer);
        return observer.getId();
    }

    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        String select = "SELECT #result('NEXT_ID' 'long' 'NEXT_ID') FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '" + entity.getName() + '\'';
        ArrayList<Query> queries = new ArrayList<Query>(2);
        queries.add(new SQLTemplate(entity, select));
        queries.add(new SQLTemplate(entity, this.pkUpdateString(entity.getName())));
        PkRetrieveProcessor observer = new PkRetrieveProcessor(entity.getName());
        node.performQueries(queries, observer);
        return observer.getId();
    }

    public int getPkCacheSize() {
        return this.pkCacheSize;
    }

    public void setPkCacheSize(int pkCacheSize) {
        this.pkCacheSize = pkCacheSize < 1 ? 1 : pkCacheSize;
    }

    @Override
    public void reset() {
        this.pkCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PkRetrieveProcessor
    implements OperationObserver {
        Number id;
        String entityName;

        PkRetrieveProcessor(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public boolean isIteratedResult() {
            return false;
        }

        public int getId() {
            if (this.id == null) {
                throw new CayenneRuntimeException("No key was retrieved for entity " + this.entityName);
            }
            return this.id.intValue();
        }

        @Override
        public void nextDataRows(Query query, List<DataRow> dataRows) {
            if (dataRows == null || dataRows.size() == 0) {
                throw new CayenneRuntimeException("Error generating PK : entity not supported: " + this.entityName);
            }
            if (dataRows.size() > 1) {
                throw new CayenneRuntimeException("Error generating PK : too many rows for entity: " + this.entityName);
            }
            DataRow lastPk = dataRows.get(0);
            this.id = (Number)lastPk.get("NEXT_ID");
        }

        @Override
        public void nextCount(Query query, int resultCount) {
            if (resultCount != 1) {
                throw new CayenneRuntimeException("Error generating PK for entity '" + this.entityName + "': update count is wrong - " + resultCount);
            }
        }

        @Override
        public void nextBatchCount(Query query, int[] resultCount) {
        }

        @Override
        public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        }

        @Override
        public void nextDataRows(Query q, ResultIterator it) {
        }

        @Override
        public void nextQueryException(Query query, Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity '" + this.entityName + "'.", ex);
        }

        @Override
        public void nextGlobalException(Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity: " + this.entityName, ex);
        }
    }
}

