/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.AbstractType;

public class ByteType
extends AbstractType {
    protected boolean widenBytes;

    public ByteType(boolean widenBytes) {
        this.widenBytes = widenBytes;
    }

    public String getClassName() {
        return Byte.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        byte b = rs.getByte(index);
        return rs.wasNull() ? null : new Byte(b);
    }

    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        byte b = st.getByte(index);
        return st.wasNull() ? null : Byte.valueOf(b);
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (this.widenBytes && val instanceof Byte) {
            val = ((Byte)val).intValue();
        }
        super.setJdbcObject(st, val, pos, type, precision);
    }
}

