/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class QueryAssemblerHelper {
    protected QueryAssembler queryAssembler;

    public QueryAssemblerHelper() {
    }

    public QueryAssemblerHelper(QueryAssembler queryAssembler) {
        this.queryAssembler = queryAssembler;
    }

    public QueryAssembler getQueryAssembler() {
        return this.queryAssembler;
    }

    public void setQueryAssembler(QueryAssembler queryAssembler) {
        this.queryAssembler = queryAssembler;
    }

    public abstract String doTranslation();

    public ObjEntity getObjEntity() {
        return this.getQueryAssembler().getRootEntity();
    }

    public DbEntity getDbEntity() {
        return this.getQueryAssembler().getRootDbEntity();
    }

    protected void appendObjPath(StringBuffer buf, Expression pathExp) {
        Iterator<CayenneMapEntry> it = this.getObjEntity().resolvePathComponents(pathExp);
        ObjRelationship lastRelationship = null;
        while (it.hasNext()) {
            CayenneMapEntry pathComp = it.next();
            if (pathComp instanceof ObjRelationship) {
                ObjRelationship rel = (ObjRelationship)pathComp;
                if (!it.hasNext()) {
                    this.processRelTermination(buf, rel);
                } else {
                    for (DbRelationship dbRel : rel.getDbRelationships()) {
                        this.queryAssembler.dbRelationshipAdded(dbRel);
                    }
                }
                lastRelationship = rel;
                continue;
            }
            ObjAttribute objAttr = (ObjAttribute)pathComp;
            if (lastRelationship != null) {
                List<DbRelationship> lastDbRelList = lastRelationship.getDbRelationships();
                DbRelationship lastDbRel = lastDbRelList.get(lastDbRelList.size() - 1);
                this.processColumn(buf, objAttr.getDbAttribute(), lastDbRel);
                continue;
            }
            this.processColumn(buf, objAttr.getDbAttribute());
        }
    }

    protected void appendDbPath(StringBuffer buf, Expression pathExp) {
        Iterator<CayenneMapEntry> it = this.getDbEntity().resolvePathComponents(pathExp);
        while (it.hasNext()) {
            CayenneMapEntry pathComp = it.next();
            if (pathComp instanceof DbRelationship) {
                DbRelationship rel = (DbRelationship)pathComp;
                if (!it.hasNext()) {
                    this.processRelTermination(buf, rel);
                    continue;
                }
                this.queryAssembler.dbRelationshipAdded(rel);
                continue;
            }
            DbAttribute dbAttr = (DbAttribute)pathComp;
            this.processColumn(buf, dbAttr);
        }
    }

    protected void processColumn(StringBuffer buf, Expression nameExp) {
        if (this.queryAssembler.supportsTableAliases()) {
            String alias = this.queryAssembler.aliasForTable(this.getDbEntity());
            buf.append(alias).append('.');
        }
        buf.append(nameExp.getOperand(0));
    }

    protected void processColumn(StringBuffer buf, DbAttribute dbAttr, DbRelationship relationship) {
        String alias = null;
        if (this.queryAssembler.supportsTableAliases()) {
            if (relationship != null) {
                alias = this.queryAssembler.aliasForTable((DbEntity)dbAttr.getEntity(), relationship);
            }
            if (alias == null) {
                alias = this.queryAssembler.aliasForTable((DbEntity)dbAttr.getEntity());
            }
        }
        buf.append(dbAttr.getAliasedName(alias));
    }

    protected void processColumn(StringBuffer buf, DbAttribute dbAttr) {
        String alias = this.queryAssembler.supportsTableAliases() ? this.queryAssembler.aliasForTable((DbEntity)dbAttr.getEntity()) : null;
        buf.append(dbAttr.getAliasedName(alias));
    }

    protected void appendLiteral(StringBuffer buf, Object val, DbAttribute attr, Expression parentExpression) {
        if (val == null) {
            buf.append("NULL");
        } else if (val instanceof Persistent) {
            ObjectId id = ((Persistent)val).getObjectId();
            if (id == null) {
                throw new CayenneRuntimeException("Can't use TRANSIENT object as a query parameter.");
            }
            if (id.isTemporary()) {
                throw new CayenneRuntimeException("Can't use NEW object as a query parameter.");
            }
            Map<String, Object> snap = id.getIdSnapshot();
            if (snap.size() != 1) {
                StringBuffer msg = new StringBuffer();
                msg.append("Object must have a single primary key column ").append("to serve as a query parameter. ").append("This object has ").append(snap.size()).append(": ").append(snap);
                throw new CayenneRuntimeException(msg.toString());
            }
            this.appendLiteralDirect(buf, snap.get(snap.keySet().iterator().next()), attr, parentExpression);
        } else {
            this.appendLiteralDirect(buf, val, attr, parentExpression);
        }
    }

    protected void appendLiteralDirect(StringBuffer buf, Object val, DbAttribute attr, Expression parentExpression) {
        buf.append('?');
        this.queryAssembler.addToParamList(attr, val);
    }

    protected DbAttribute paramsDbType(Expression e) {
        int len = e.getOperandCount();
        if (len < 2) {
            Expression parent;
            if (e instanceof SimpleNode && (parent = (Expression)((Object)((SimpleNode)e).jjtGetParent())) != null) {
                return this.paramsDbType(parent);
            }
            return null;
        }
        DbAttribute attribute = null;
        DbRelationship relationship = null;
        for (int i = 0; i < len; ++i) {
            Object last;
            Object op = e.getOperand(i);
            if (!(op instanceof Expression)) continue;
            Expression expression = (Expression)op;
            if (expression.getType() == 26) {
                ObjRelationship objRelationship;
                List<DbRelationship> dbPath;
                last = this.getObjEntity().lastPathComponent(expression);
                if (last instanceof EmbeddableAttribute) break;
                if (last instanceof ObjAttribute) {
                    attribute = ((ObjAttribute)last).getDbAttribute();
                    break;
                }
                if (!(last instanceof ObjRelationship) || (dbPath = (objRelationship = (ObjRelationship)last).getDbRelationships()).size() <= 0) continue;
                relationship = dbPath.get(dbPath.size() - 1);
                break;
            }
            if (expression.getType() != 27) continue;
            last = this.getDbEntity().lastPathComponent(expression);
            if (last instanceof DbAttribute) {
                attribute = (DbAttribute)last;
                break;
            }
            if (!(last instanceof DbRelationship)) continue;
            relationship = (DbRelationship)last;
            break;
        }
        if (attribute != null) {
            return attribute;
        }
        if (relationship != null && relationship.getJoins().size() == 1) {
            DbJoin join = relationship.getJoins().get(0);
            return join.getSource();
        }
        return null;
    }

    protected void processRelTermination(StringBuffer buf, ObjRelationship rel) {
        Iterator<DbRelationship> dbRels = rel.getDbRelationships().iterator();
        while (dbRels.hasNext()) {
            DbRelationship dbRel = dbRels.next();
            if (!dbRels.hasNext()) {
                this.processRelTermination(buf, dbRel);
                continue;
            }
            this.queryAssembler.dbRelationshipAdded(dbRel);
        }
    }

    protected void processRelTermination(StringBuffer buf, DbRelationship rel) {
        List<DbJoin> joins;
        if (rel.isToMany()) {
            this.queryAssembler.dbRelationshipAdded(rel);
        }
        if ((joins = rel.getJoins()).size() != 1) {
            StringBuffer msg = new StringBuffer();
            msg.append("OBJ_PATH expressions are only supported ").append("for a single-join relationships. ").append("This relationship has ").append(joins.size()).append(" joins.");
            throw new CayenneRuntimeException(msg.toString());
        }
        DbJoin join = joins.get(0);
        DbAttribute attribute = null;
        if (rel.isToMany()) {
            DbEntity ent = (DbEntity)join.getRelationship().getTargetEntity();
            Collection<DbAttribute> pk = ent.getPrimaryKeys();
            if (pk.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("DB_NAME expressions can only support ").append("targets with a single column PK. ").append("This entity has ").append(pk.size()).append(" columns in primary key.");
                throw new CayenneRuntimeException(msg.toString());
            }
            attribute = pk.iterator().next();
        } else {
            attribute = join.getSource();
        }
        this.processColumn(buf, attribute);
    }
}

