/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLTemplateAction
implements SQLAction {
    protected DbAdapter adapter;
    protected SQLTemplate query;

    public SQLTemplateAction(SQLTemplate query, DbAdapter adapter) {
        this.query = query;
        this.adapter = adapter;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void performAction(Connection connection, OperationObserver callback) throws SQLException, Exception {
        String template = this.extractTemplateString();
        if (template == null) {
            throw new CayenneException("No template string configured for adapter " + this.getAdapter().getClass().getName());
        }
        boolean loggable = QueryLogger.isLoggable();
        int size = this.query.parametersSize();
        SQLTemplateProcessor templateProcessor = new SQLTemplateProcessor();
        int batchSize = size > 0 ? size : 1;
        ArrayList<Number> counts = new ArrayList<Number>(batchSize);
        Iterator<Object> it = size > 0 ? this.query.parametersIterator() : IteratorUtils.singletonIterator((Object)Collections.EMPTY_MAP);
        for (int i = 0; i < batchSize; ++i) {
            Map nextParameters = (Map)it.next();
            SQLStatement compiled = templateProcessor.processTemplate(template, nextParameters);
            if (loggable) {
                QueryLogger.logQuery(compiled.getSql(), Arrays.asList(compiled.getBindings()));
            }
            this.execute(connection, callback, compiled, counts);
        }
        int[] ints = new int[counts.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = ((Number)counts.get(i)).intValue();
        }
        callback.nextBatchCount(this.query, ints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection connection, OperationObserver callback, SQLStatement compiled, Collection<Number> updateCounts) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        boolean iteratedResult = callback.isIteratedResult();
        PreparedStatement statement = connection.prepareStatement(compiled.getSql());
        try {
            this.bind(statement, compiled.getBindings());
            boolean isResultSet = statement.execute();
            boolean firstIteration = true;
            while (true) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    isResultSet = statement.getMoreResults();
                }
                if (isResultSet) {
                    ResultSet resultSet = statement.getResultSet();
                    if (resultSet == null) continue;
                    try {
                        this.processSelectResult(compiled, connection, statement, resultSet, callback, t1);
                    }
                    finally {
                        if (!iteratedResult) {
                            resultSet.close();
                        }
                    }
                    if (!iteratedResult) continue;
                    break;
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                updateCounts.add(updateCount);
                QueryLogger.logUpdateCount(updateCount);
            }
        }
        finally {
            if (!iteratedResult) {
                statement.close();
            }
        }
    }

    protected void processSelectResult(SQLStatement compiled, Connection connection, Statement statement, ResultSet resultSet, OperationObserver callback, long startTime) throws Exception {
        RowDescriptor descriptor;
        boolean iteratedResult = callback.isIteratedResult();
        ExtendedTypeMap types = this.adapter.getExtendedTypes();
        RowDescriptor rowDescriptor = descriptor = compiled.getResultColumns().length > 0 ? new RowDescriptor(compiled.getResultColumns(), types) : new RowDescriptor(resultSet, types);
        if (this.query.getColumnNamesCapitalization() != null) {
            if ("lower".equals(this.query.getColumnNamesCapitalization())) {
                descriptor.forceLowerCaseColumnNames();
            } else if ("upper".equals(this.query.getColumnNamesCapitalization())) {
                descriptor.forceUpperCaseColumnNames();
            }
        }
        JDBCResultIterator result = new JDBCResultIterator(connection, statement, resultSet, descriptor, this.query.getFetchLimit());
        if (!iteratedResult) {
            List<DataRow> resultRows = result.dataRows(false);
            QueryLogger.logSelectCount(resultRows.size(), System.currentTimeMillis() - startTime);
            callback.nextDataRows((Query)this.query, resultRows);
        } else {
            try {
                result.setClosingConnection(true);
                callback.nextDataRows((Query)this.query, result);
            }
            catch (Exception ex) {
                result.close();
                throw ex;
            }
        }
    }

    protected String extractTemplateString() {
        String sql = this.query.getTemplate(this.getAdapter().getClass().getName());
        return Util.stripLineBreaks(sql, " ");
    }

    protected void bind(PreparedStatement preparedStatement, ParameterBinding[] bindings) throws SQLException, Exception {
        if (bindings.length > 0) {
            int len = bindings.length;
            for (int i = 0; i < len; ++i) {
                this.adapter.bindParameter(preparedStatement, bindings[i].getValue(), i + 1, bindings[i].getJdbcType(), bindings[i].getPrecision());
            }
        }
    }

    public boolean isRemovingLineBreaks() {
        return true;
    }

    public void setRemovingLineBreaks(boolean removingLineBreaks) {
    }

    public SQLTemplate getQuery() {
        return this.query;
    }
}

