/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ListWithPrefetches;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectTreeResolver;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDomainQueryAction
implements QueryRouter,
OperationObserver {
    static final boolean DONE = true;
    DataContext context;
    DataDomain domain;
    DataRowStore cache;
    Query query;
    QueryMetadata metadata;
    QueryResponse response;
    GenericResponse fullResponse;
    Map prefetchResultsByPath;
    Map<QueryEngine, Collection<Query>> queriesByNode;
    Map<Query, Query> queriesByExecutedQueries;
    boolean noObjectConversion;

    DataDomainQueryAction(ObjectContext context, DataDomain domain, Query query) {
        if (context != null && !(context instanceof DataContext)) {
            throw new IllegalArgumentException("DataDomain can only work with DataContext. Unsupported context type: " + context);
        }
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.context = (DataContext)context;
        if (context != null) {
            this.cache = this.context.getObjectStore().getDataRowCache();
        }
        if (this.cache == null) {
            this.cache = domain.getSharedSnapshotCache();
        }
    }

    QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptRefreshQuery() || this.interceptSharedCache() || this.interceptDataDomainQuery())) {
            this.runQueryInTransaction();
        }
        if (!this.noObjectConversion) {
            if (!this.interceptMappedConversion()) {
                this.interceptObjectConversion();
            }
            this.invokePostLoad();
        }
        return this.response;
    }

    private void invokePostLoad() {
        List list;
        LifecycleCallbackRegistry callbackRegistry = this.domain.getEntityResolver().getCallbackRegistry();
        if (!(callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD) || (list = this.response.firstList()) == null || list.isEmpty() || this.query.getMetaData(this.domain.getEntityResolver()).isFetchingDataRows())) {
            callbackRegistry.performCallbacks(LifecycleEvent.POST_LOAD, list);
        }
    }

    private boolean interceptDataDomainQuery() {
        if (this.query instanceof DataDomainQuery) {
            this.response = new ListResponse(this.domain);
            return true;
        }
        return false;
    }

    private boolean interceptOIDQuery() {
        if (this.query instanceof ObjectIdQuery) {
            ObjectIdQuery oidQuery = (ObjectIdQuery)this.query;
            DataRow row = null;
            if (this.cache != null && !oidQuery.isFetchMandatory()) {
                row = this.cache.getCachedSnapshot(oidQuery.getObjectId());
            }
            if (row == null) {
                if (oidQuery.isFetchAllowed()) {
                    this.runQueryInTransaction();
                } else {
                    this.response = new ListResponse();
                }
            } else {
                this.response = new ListResponse(row);
            }
            return true;
        }
        return false;
    }

    private boolean interceptRelationshipQuery() {
        if (this.query instanceof RelationshipQuery) {
            RelationshipQuery relationshipQuery = (RelationshipQuery)this.query;
            if (relationshipQuery.isRefreshing()) {
                return false;
            }
            ObjRelationship relationship = relationshipQuery.getRelationship(this.domain.getEntityResolver());
            if (relationship.isSourceIndependentFromTargetChange()) {
                return false;
            }
            if (this.cache == null) {
                return false;
            }
            DataRow sourceRow = this.cache.getCachedSnapshot(relationshipQuery.getObjectId());
            if (sourceRow == null) {
                return false;
            }
            DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
            ObjectId targetId = sourceRow.createTargetObjectId(relationship.getTargetEntityName(), dbRelationship);
            if (targetId == null) {
                this.response = new GenericResponse(Collections.EMPTY_LIST);
                return true;
            }
            DataRow targetRow = this.cache.getCachedSnapshot(targetId);
            if (targetRow != null) {
                this.response = new GenericResponse(Collections.singletonList(targetRow));
                return true;
            }
            if (this.context != null && this.domain.getEntityResolver().lookupInheritanceTree((ObjEntity)relationship.getTargetEntity()) == null) {
                this.noObjectConversion = true;
                Persistent object = this.context.localObject(targetId, null);
                this.response = new GenericResponse(Collections.singletonList(object));
                return true;
            }
        }
        return false;
    }

    private boolean interceptRefreshQuery() {
        if (this.query instanceof RefreshQuery) {
            RefreshQuery refreshQuery = (RefreshQuery)this.query;
            if (refreshQuery.isRefreshAll()) {
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().clear();
                }
                this.context.getQueryCache().clear();
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            Collection<?> objects = refreshQuery.getObjects();
            if (objects != null && !objects.isEmpty()) {
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
                for (Persistent object : objects) {
                    ids.add(object.getObjectId());
                }
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().processSnapshotChanges(this.context.getObjectStore(), Collections.EMPTY_MAP, Collections.EMPTY_LIST, ids, Collections.EMPTY_LIST);
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            if (refreshQuery.getQuery() != null) {
                Query cachedQuery = refreshQuery.getQuery();
                String cacheKey = cachedQuery.getMetaData(this.context.getEntityResolver()).getCacheKey();
                this.context.getQueryCache().remove(cacheKey);
                this.response = this.domain.onQuery(this.context, cachedQuery);
                return true;
            }
            if (refreshQuery.getGroupKeys() != null && refreshQuery.getGroupKeys().length > 0) {
                String[] groups;
                for (String group : groups = refreshQuery.getGroupKeys()) {
                    this.domain.getQueryCache().removeGroup(group);
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
        }
        return false;
    }

    private final boolean interceptSharedCache() {
        boolean cacheOrCacheRefresh;
        if (this.metadata.getCacheKey() == null) {
            return false;
        }
        boolean cache = "sharedcache".equals(this.metadata.getCachePolicy());
        boolean bl = cacheOrCacheRefresh = cache || "sharedcache_refresh".equals(this.metadata.getCachePolicy());
        if (!cacheOrCacheRefresh) {
            return false;
        }
        QueryCache queryCache = this.domain.getQueryCache();
        QueryCacheEntryFactory factory = this.getCacheObjectFactory();
        if (cache) {
            List cachedResults = queryCache.get(this.metadata, factory);
            if (this.response == null) {
                this.response = new ListResponse(cachedResults);
            }
            if (cachedResults instanceof ListWithPrefetches) {
                this.prefetchResultsByPath = ((ListWithPrefetches)cachedResults).getPrefetchResultsByPath();
            }
        } else {
            queryCache.put(this.metadata, (List)factory.createObject());
        }
        return true;
    }

    private QueryCacheEntryFactory getCacheObjectFactory() {
        return new QueryCacheEntryFactory(){

            public Object createObject() {
                DataDomainQueryAction.this.runQueryInTransaction();
                ListWithPrefetches list = DataDomainQueryAction.this.response.firstList();
                if (list != null) {
                    list = Collections.unmodifiableList(list);
                    if (DataDomainQueryAction.this.prefetchResultsByPath != null) {
                        list = new ListWithPrefetches(list, DataDomainQueryAction.this.prefetchResultsByPath);
                    }
                }
                return list;
            }
        };
    }

    void runQueryInTransaction() {
        this.domain.runInTransaction(new Transformer(){

            public Object transform(Object input) {
                DataDomainQueryAction.this.runQuery();
                return null;
            }
        });
    }

    private void runQuery() {
        this.fullResponse = new GenericResponse();
        this.response = this.fullResponse;
        this.queriesByNode = null;
        this.queriesByExecutedQueries = null;
        this.prefetchResultsByPath = this.metadata.getPrefetchTree() != null && !this.metadata.isFetchingDataRows() ? new HashMap() : null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            for (Map.Entry<QueryEngine, Collection<Query>> entry : this.queriesByNode.entrySet()) {
                QueryEngine nextNode = entry.getKey();
                Collection<Query> nodeQueries = entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    private void interceptObjectConversion() {
        List mainRows;
        if (this.context != null && !this.metadata.isFetchingDataRows() && (mainRows = this.response.firstList()) != null && !mainRows.isEmpty()) {
            List objects;
            ClassDescriptor descriptor = this.metadata.getClassDescriptor();
            PrefetchTreeNode prefetchTree = this.metadata.getPrefetchTree();
            if (prefetchTree == null) {
                objects = new ObjectResolver(this.context, descriptor, this.metadata.isRefreshingObjects(), this.metadata.isResolvingInherited()).synchronizedObjectsFromDataRows(mainRows);
            } else {
                ObjectTreeResolver resolver = new ObjectTreeResolver(this.context, this.metadata);
                objects = resolver.synchronizedObjectsFromDataRows(prefetchTree, mainRows, this.prefetchResultsByPath);
            }
            if (this.response instanceof GenericResponse) {
                ((GenericResponse)this.response).replaceResult(mainRows, objects);
            } else if (this.response instanceof ListResponse) {
                this.response = new ListResponse(objects);
            } else {
                throw new IllegalStateException("Unknown response object: " + this.response);
            }
            LifecycleCallbackRegistry callbackRegistry = this.context.getEntityResolver().getCallbackRegistry();
            if (!callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD)) {
                callbackRegistry.performCallbacks(LifecycleEvent.POST_LOAD, objects);
            }
        }
    }

    private boolean interceptMappedConversion() {
        SQLResultSetMapping rsMapping = this.metadata.getResultSetMapping();
        if (rsMapping == null) {
            return false;
        }
        List mainRows = this.response.firstList();
        if (mainRows != null && !mainRows.isEmpty()) {
            List<String> columns = rsMapping.getColumnResults();
            if (columns.isEmpty()) {
                throw new CayenneRuntimeException("Invalid result set mapping, no columns mapped.");
            }
            Object[] columnsArray = columns.toArray();
            int rowsLen = mainRows.size();
            int rowWidth = columnsArray.length;
            ArrayList<Object> objects = new ArrayList<Object>(rowsLen);
            if (rowWidth == 1) {
                for (int i = 0; i < rowsLen; ++i) {
                    Map row = (Map)mainRows.get(i);
                    objects.add(row.get(columnsArray[0]));
                }
            } else {
                for (int i = 0; i < rowsLen; ++i) {
                    Map row = (Map)mainRows.get(i);
                    Object[] rowDecoded = new Object[rowWidth];
                    for (int j = 0; j < rowWidth; ++j) {
                        rowDecoded[j] = row.get(columnsArray[j]);
                    }
                    objects.add(rowDecoded);
                }
            }
            if (this.response instanceof GenericResponse) {
                ((GenericResponse)this.response).replaceResult(mainRows, objects);
            } else if (this.response instanceof ListResponse) {
                this.response = new ListResponse(objects);
            } else {
                throw new IllegalStateException("Unknown response object: " + this.response);
            }
        }
        return true;
    }

    @Override
    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        Collection<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap<QueryEngine, Collection<Query>>();
        } else {
            queries = this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
        if (substitutedQuery != null && substitutedQuery != query) {
            if (this.queriesByExecutedQueries == null) {
                this.queriesByExecutedQueries = new HashMap<Query, Query>();
            }
            this.queriesByExecutedQueries.put(query, substitutedQuery);
        }
    }

    @Override
    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap " + map);
        }
        return node;
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        this.fullResponse.addUpdateCount(resultCount);
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        this.fullResponse.addBatchUpdateCount(resultCount);
    }

    @Override
    public void nextDataRows(Query query, List<DataRow> dataRows) {
        if (this.prefetchResultsByPath != null && query instanceof PrefetchSelectQuery) {
            PrefetchSelectQuery prefetchQuery = (PrefetchSelectQuery)query;
            this.prefetchResultsByPath.put(prefetchQuery.getPrefetchPath(), dataRows);
        } else {
            this.fullResponse.addResultList(dataRows);
        }
    }

    @Override
    public void nextDataRows(Query q, ResultIterator it) {
        throw new CayenneRuntimeException("Invalid attempt to fetch a cursor.");
    }

    @Override
    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        if (keysIterator != null) {
            try {
                this.nextDataRows(query, keysIterator.dataRows(true));
            }
            catch (CayenneException ex) {
                this.nextQueryException(query, ex);
            }
        }
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex));
    }

    @Override
    public void nextGlobalException(Exception e) {
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(e));
    }

    @Override
    public boolean isIteratedResult() {
        return false;
    }
}

