/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

final class DataDomainIndirectDiffBuilder
implements GraphChangeHandler {
    private final DataDomainFlushAction parent;
    private final EntityResolver resolver;
    private final Collection indirectModifications;
    private final Collection flattenedInserts;
    private final Collection flattenedDeletes;

    DataDomainIndirectDiffBuilder(DataDomainFlushAction parent) {
        this.parent = parent;
        this.indirectModifications = parent.getResultIndirectlyModifiedIds();
        this.resolver = parent.getDomain().getEntityResolver();
        this.flattenedInserts = new HashSet();
        this.flattenedDeletes = new HashSet();
    }

    void processIndirectChanges(GraphDiff allChanges) {
        DbEntity entity;
        allChanges.apply(this);
        if (!this.flattenedInserts.isEmpty()) {
            for (FlattenedArcKey key : this.flattenedInserts) {
                entity = key.getJoinEntity();
                this.parent.addFlattenedInsert(entity, key);
            }
        }
        if (!this.flattenedDeletes.isEmpty()) {
            for (FlattenedArcKey key : this.flattenedDeletes) {
                entity = key.getJoinEntity();
                this.parent.addFlattenedDelete(entity, key);
            }
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = (ObjRelationship)entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            if (!((ObjectId)nodeId).isTemporary()) {
                this.indirectModifications.add(nodeId);
            }
            if (relationship.isFlattened()) {
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot set the read-only flattened relationship '" + relationship.getName() + "' in ObjEntity '" + relationship.getSourceEntity().getName() + "'.");
                }
                FlattenedArcKey key = new FlattenedArcKey((ObjectId)nodeId, (ObjectId)targetNodeId, relationship);
                if (!this.flattenedDeletes.remove(key)) {
                    this.flattenedInserts.add(key);
                }
            }
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = (ObjRelationship)entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            if (!((ObjectId)nodeId).isTemporary()) {
                this.indirectModifications.add(nodeId);
            }
            if (relationship.isFlattened()) {
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot unset the read-only flattened relationship " + relationship.getName());
                }
                FlattenedArcKey key = new FlattenedArcKey((ObjectId)nodeId, (ObjectId)targetNodeId, relationship);
                if (!this.flattenedInserts.remove(key)) {
                    this.flattenedDeletes.add(key);
                }
            }
        }
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodeCreated(Object nodeId) {
    }

    public void nodeRemoved(Object nodeId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }
}

