/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.HierarchicalTreeVisitor;
import org.apache.cayenne.util.TreeNodeChild;

public class TraversalUtil {
    static final ClassTraversalDescriptor noopDescriptor = new ClassTraversalDescriptor();
    static final Map<String, ClassTraversalDescriptor> descriptors = new HashMap<String, ClassTraversalDescriptor>();

    private static Method[] traversableGetters(Class nodeType) {
        ArrayList<Method> getters = null;
        Method[] methods = nodeType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(TreeNodeChild.class) || Void.TYPE.equals(methods[i].getReturnType())) continue;
            if (getters == null) {
                getters = new ArrayList<Method>(5);
            }
            getters.add(methods[i]);
        }
        return getters != null ? getters.toArray(new Method[getters.size()]) : null;
    }

    static synchronized ClassTraversalDescriptor getDescriptor(Class nodeType) {
        String typeName = nodeType.getName();
        ClassTraversalDescriptor descriptor = descriptors.get(typeName);
        if (descriptor == null) {
            Method[] getters = TraversalUtil.traversableGetters(nodeType);
            descriptor = getters != null ? new ClassTraversalDescriptor(getters) : noopDescriptor;
            descriptors.put(typeName, descriptor);
        }
        return descriptor;
    }

    public static void traverse(Object treeRoot, HierarchicalTreeVisitor visitor) {
        TraversalUtil.traverse(treeRoot, visitor, null);
    }

    static void traverse(Object node, HierarchicalTreeVisitor visitor, ProjectPath parentPath) {
        ProjectPath path;
        ProjectPath projectPath = path = parentPath != null ? parentPath.appendToPath(node) : new ProjectPath(node);
        if (visitor.onStartNode(path)) {
            ClassTraversalDescriptor descriptor = TraversalUtil.getDescriptor(node.getClass());
            Class[] childTypes = descriptor.getTraversableChildTypes();
            if (childTypes != null && childTypes.length > 0) {
                for (int i = 0; i < childTypes.length; ++i) {
                    Object child;
                    HierarchicalTreeVisitor childVisitor = visitor.childVisitor(path, childTypes[i]);
                    if (childVisitor == null || (child = descriptor.getTraversableChild(node, i)) == null) continue;
                    if (child instanceof Collection) {
                        Collection children = (Collection)child;
                        if (children == null || children.isEmpty()) continue;
                        for (Object collectionChild : children) {
                            TraversalUtil.traverse(collectionChild, childVisitor, path);
                        }
                        continue;
                    }
                    TraversalUtil.traverse(child, childVisitor, path);
                }
            }
            visitor.onFinishNode(path);
        }
    }

    static class ClassTraversalDescriptor {
        Class[] traversableChildTypes;
        Method[] traversableGetters;

        ClassTraversalDescriptor() {
        }

        ClassTraversalDescriptor(Method[] traversableChildGetters) {
            this.traversableGetters = traversableChildGetters;
            this.traversableChildTypes = new Class[traversableChildGetters.length];
            for (int i = 0; i < traversableChildGetters.length; ++i) {
                Class type = traversableChildGetters[i].getReturnType();
                if (Collection.class.isAssignableFrom(type) && Void.TYPE.equals(type = traversableChildGetters[i].getAnnotation(TreeNodeChild.class).type())) {
                    throw new JpaProviderException("No type for collection defined: " + traversableChildGetters[i].getName());
                }
                this.traversableChildTypes[i] = type;
            }
        }

        Class[] getTraversableChildTypes() {
            return this.traversableChildTypes;
        }

        Object getTraversableChild(Object object, int childIndex) {
            try {
                return this.traversableGetters[childIndex].invoke(object, (Object[])null);
            }
            catch (Exception e) {
                throw new JpaProviderException("Error reading traversible property", e);
            }
        }
    }
}

