/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ListResponse;

public abstract class ObjectContextQueryAction {
    protected static final boolean DONE = true;
    protected ObjectContext targetContext;
    protected ObjectContext actingContext;
    protected Query query;
    protected QueryMetadata metadata;
    protected transient QueryResponse response;

    public ObjectContextQueryAction(ObjectContext actingContext, ObjectContext targetContext, Query query) {
        this.actingContext = actingContext;
        this.query = query;
        this.targetContext = targetContext != actingContext ? targetContext : null;
        this.metadata = query.getMetaData(actingContext.getEntityResolver());
    }

    public QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptLocalCache())) {
            this.runQuery();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    protected void interceptObjectConversion() {
        if (this.targetContext != null && !this.metadata.isFetchingDataRows()) {
            GenericResponse childResponse = new GenericResponse();
            this.response.reset();
            while (this.response.next()) {
                if (this.response.isList()) {
                    List objects = this.response.currentList();
                    if (objects.isEmpty()) {
                        childResponse.addResultList(objects);
                        continue;
                    }
                    ArrayList<Persistent> childObjects = new ArrayList<Persistent>(objects.size());
                    Iterator it = objects.iterator();
                    while (it.hasNext()) {
                        Persistent object = (Persistent)it.next();
                        childObjects.add(this.targetContext.localObject(object.getObjectId(), object));
                    }
                    childResponse.addResultList(childObjects);
                    continue;
                }
                childResponse.addBatchUpdateCount(this.response.currentUpdateCount());
            }
            this.response = childResponse;
        }
    }

    protected boolean interceptOIDQuery() {
        Object object;
        ObjectIdQuery oidQuery;
        if (this.query instanceof ObjectIdQuery && !(oidQuery = (ObjectIdQuery)this.query).isFetchMandatory() && !oidQuery.isFetchingDataRows() && (object = this.actingContext.getGraphManager().getNode(oidQuery.getObjectId())) != null) {
            if (((Persistent)object).getPersistenceState() == 5) {
                return false;
            }
            this.response = new ListResponse(object);
            return true;
        }
        return false;
    }

    protected boolean interceptRelationshipQuery() {
        RelationshipQuery relationshipQuery;
        if (this.query instanceof RelationshipQuery && !(relationshipQuery = (RelationshipQuery)this.query).isRefreshing()) {
            ArcProperty property;
            ClassDescriptor descriptor;
            if (this.targetContext == null && relationshipQuery.getRelationship(this.actingContext.getEntityResolver()).isToMany()) {
                return false;
            }
            ObjectId id = relationshipQuery.getObjectId();
            Object object = this.actingContext.getGraphManager().getNode(id);
            if (object != null && !(descriptor = this.actingContext.getEntityResolver().getClassDescriptor(id.getEntityName())).isFault(object) && !(property = (ArcProperty)descriptor.getProperty(relationshipQuery.getRelationshipName())).isFault(object)) {
                List<Object> result;
                Object related = property.readPropertyDirectly(object);
                if (related == null) {
                    result = new ArrayList(1);
                } else if (related instanceof List) {
                    result = (List)related;
                } else {
                    result = new ArrayList(1);
                    result.add(related);
                }
                this.response = new ListResponse(result);
                return true;
            }
        }
        return false;
    }

    protected boolean interceptLocalCache() {
        boolean cacheOrCacheRefresh;
        if (this.metadata.getCacheKey() == null) {
            return false;
        }
        boolean cache = "localcache".equals(this.metadata.getCachePolicy());
        boolean bl = cacheOrCacheRefresh = cache || "localcache_refresh".equals(this.metadata.getCachePolicy());
        if (!cacheOrCacheRefresh) {
            return false;
        }
        QueryCache queryCache = this.getQueryCache();
        QueryCacheEntryFactory factory = this.getCacheObjectFactory();
        if (cache) {
            List cachedResults = queryCache.get(this.metadata, factory);
            if (this.response == null) {
                this.response = new ListResponse(cachedResults);
            }
        } else {
            queryCache.put(this.metadata, (List)factory.createObject());
        }
        return true;
    }

    protected abstract QueryCache getQueryCache();

    protected QueryCacheEntryFactory getCacheObjectFactory() {
        return new QueryCacheEntryFactory(){

            public Object createObject() {
                ObjectContextQueryAction.this.runQuery();
                return ObjectContextQueryAction.this.response.firstList();
            }
        };
    }

    protected void runQuery() {
        this.response = this.actingContext.getChannel().onQuery(this.actingContext, this.query);
    }
}

