/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.PersistentObjectList;

public class IndexPropertyList
extends AbstractList
implements ValueHolder {
    static final int DEFAULT_GAP = 3;
    protected List list;
    protected String indexProperty;
    boolean dirty;
    Comparator comparator;

    public IndexPropertyList(String indexProperty) {
        this(indexProperty, new ArrayList(), false);
    }

    public IndexPropertyList(String indexProperty, List objects, boolean sortNeeded) {
        if (indexProperty == null) {
            throw new IllegalArgumentException("Null sortProperty");
        }
        if (objects == null) {
            throw new IllegalArgumentException("Null objects list.");
        }
        this.indexProperty = indexProperty;
        this.list = objects;
        this.dirty = sortNeeded;
    }

    ValueHolder getWrappedValueHolder() {
        return this.list instanceof ValueHolder ? (ValueHolder)((Object)this.list) : null;
    }

    public boolean isFault() {
        ValueHolder h = this.getWrappedValueHolder();
        return h != null ? h.isFault() : false;
    }

    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        ValueHolder h = this.getWrappedValueHolder();
        return h != null ? h.setValueDirectly(value) : null;
    }

    public Object setValue(Object value) throws CayenneRuntimeException {
        ValueHolder h = this.getWrappedValueHolder();
        return h != null ? h.setValue(value) : null;
    }

    public Object getValue() throws CayenneRuntimeException {
        ValueHolder h = this.getWrappedValueHolder();
        return h != null ? h.getValue() : null;
    }

    public Object getValueDirectly() throws CayenneRuntimeException {
        ValueHolder h = this.getWrappedValueHolder();
        return h != null ? h.getValueDirectly() : null;
    }

    public void invalidate() {
        ValueHolder h = this.getWrappedValueHolder();
        if (h != null) {
            h.invalidate();
        }
    }

    public void touch() {
        this.dirty = true;
    }

    public Object get(int index) {
        if (this.dirty) {
            this.sort();
        }
        return this.list.get(index);
    }

    public int size() {
        if (this.dirty) {
            this.sort();
        }
        return this.list.size();
    }

    public Object set(int index, Object element) {
        if (this.dirty) {
            this.sort();
        }
        Object removed = this.list.set(index, element);
        if (element != null) {
            int indexValue = removed != null ? this.getIndexValue(removed) : this.calculateIndexValue(index);
            this.setIndexValue(element, indexValue);
            this.shift(index + 1, indexValue);
        }
        if (removed != null && removed != element) {
            this.setIndexValue(removed, -1);
        }
        return removed;
    }

    public void add(int index, Object element) {
        if (this.dirty) {
            this.sort();
        }
        this.list.add(index, element);
        if (element != null) {
            int indexValue = this.calculateIndexValue(index);
            this.setIndexValue(element, indexValue);
            this.shift(index + 1, indexValue);
        }
    }

    public Object remove(int index) {
        Object removed;
        if (this.dirty) {
            this.sort();
        }
        if ((removed = this.list.remove(index)) != null) {
            this.setIndexValue(removed, -1);
        }
        return removed;
    }

    protected int calculateIndexValue(int listIndex) {
        if (this.list.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException(listIndex);
        }
        if (this.list.size() == 1 && listIndex == 0) {
            return 0;
        }
        if (listIndex == this.list.size() - 1) {
            return this.getIndexValue(this.get(listIndex - 1)) + 3;
        }
        int from = listIndex == 0 ? -1 : this.getIndexValue(this.get(listIndex - 1));
        int to = this.getIndexValue(this.get(listIndex + 1));
        return to - from > 1 ? (to - from) / 2 + from : from + 3;
    }

    protected int getIndexValue(Object object) {
        Number n = (Number)PropertyUtils.getProperty(object, this.indexProperty);
        if (n == null) {
            throw new CayenneRuntimeException("Null index property '" + this.indexProperty + "' for object " + object);
        }
        return n.intValue();
    }

    protected void setIndexValue(Object object, int index) {
        PropertyUtils.setProperty(object, this.indexProperty, new Integer(index));
    }

    protected void shift(int startIndex, int afterIndexValue) {
        Object object;
        int indexValue;
        int size = this.size();
        for (int i = startIndex; i < size && (indexValue = this.getIndexValue(object = this.get(i))) <= afterIndexValue; ++i) {
            int newValue = this.calculateIndexValue(i);
            this.setIndexValue(object, newValue);
            afterIndexValue = newValue;
        }
    }

    protected void sort() {
        if (!this.dirty) {
            return;
        }
        Collections.sort(this.unwrapList(), this.getComparator());
        this.dirty = false;
    }

    List unwrapList() {
        if (this.list instanceof PersistentObjectList) {
            return ((PersistentObjectList)this.list).resolvedObjectList();
        }
        return this.list;
    }

    Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 == null || o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    Comparable p1 = (Comparable)PropertyUtils.getProperty(o1, IndexPropertyList.this.indexProperty);
                    Comparable p2 = (Comparable)PropertyUtils.getProperty(o2, IndexPropertyList.this.indexProperty);
                    return p1 == null ? -1 : p1.compareTo(p2);
                }
            };
        }
        return this.comparator;
    }
}

