/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.commons.collections.IteratorUtils;

public class PersistentDescriptor
implements ClassDescriptor {
    static final Integer TRANSIENT_STATE = new Integer(1);
    static final Integer HOLLOW_STATE = new Integer(5);
    static final Integer COMMITTED_STATE = new Integer(3);
    protected ClassDescriptor superclassDescriptor;
    protected Class objectClass;
    protected Map declaredProperties = new HashMap();
    protected Map subclassDescriptors = new HashMap();
    protected Accessor persistenceStateAccessor;
    protected ObjEntity entity;
    protected Collection declaredIdProperties;
    protected Collection declaredMapArcProperties;

    public void addDeclaredProperty(Property property) {
        ObjRelationship relationship;
        ObjRelationship reverseRelationship;
        this.declaredProperties.put(property.getName(), property);
        if (property instanceof AttributeProperty) {
            ObjAttribute attribute = ((AttributeProperty)property).getAttribute();
            if (attribute.getDbAttributeName() != null && attribute.getDbAttribute().isPrimaryKey()) {
                if (this.declaredIdProperties == null) {
                    this.declaredIdProperties = new ArrayList(2);
                }
                this.declaredIdProperties.add(property);
            }
        } else if (property instanceof ArcProperty && (reverseRelationship = (relationship = ((ArcProperty)property).getRelationship()).getReverseRelationship()) != null && "java.util.Map".equals(reverseRelationship.getCollectionType())) {
            if (this.declaredMapArcProperties == null) {
                this.declaredMapArcProperties = new ArrayList(2);
            }
            this.declaredMapArcProperties.add(property);
        }
    }

    public void removeDeclaredProperty(String propertyName) {
        Object removed = this.declaredProperties.remove(propertyName);
        if (removed != null) {
            if (this.declaredIdProperties != null) {
                this.declaredIdProperties.remove(removed);
            }
            if (this.declaredMapArcProperties != null) {
                this.declaredMapArcProperties.remove(removed);
            }
        }
    }

    public void addSubclassDescriptor(ClassDescriptor subclassDescriptor) {
        this.subclassDescriptors.put(subclassDescriptor.getEntity().getClassName(), subclassDescriptor);
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public boolean isFault(Object object) {
        if (this.superclassDescriptor != null) {
            return this.superclassDescriptor.isFault(object);
        }
        if (object == null) {
            return false;
        }
        return HOLLOW_STATE.equals(this.persistenceStateAccessor.getValue(object));
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public ClassDescriptor getSubclassDescriptor(Class objectClass) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (this.subclassDescriptors.isEmpty()) {
            return this;
        }
        ClassDescriptor subclassDescriptor = (ClassDescriptor)this.subclassDescriptors.get(objectClass.getName());
        if (subclassDescriptor == null) {
            Class currentClass = objectClass;
            while (subclassDescriptor == null && (currentClass = currentClass.getSuperclass()) != null) {
                subclassDescriptor = (ClassDescriptor)this.subclassDescriptors.get(currentClass.getName());
            }
        }
        return subclassDescriptor != null ? subclassDescriptor : this;
    }

    public Iterator getProperties() {
        Iterator declaredIt = IteratorUtils.unmodifiableIterator(this.declaredProperties.values().iterator());
        if (this.getSuperclassDescriptor() == null) {
            return declaredIt;
        }
        return IteratorUtils.chainedIterator((Iterator)this.superclassDescriptor.getProperties(), (Iterator)declaredIt);
    }

    public Iterator getIdProperties() {
        Iterator it = null;
        if (this.getSuperclassDescriptor() != null) {
            it = this.getSuperclassDescriptor().getIdProperties();
        }
        if (this.declaredIdProperties != null) {
            it = it != null ? IteratorUtils.chainedIterator(it, this.declaredIdProperties.iterator()) : this.declaredIdProperties.iterator();
        }
        return it != null ? it : IteratorUtils.EMPTY_ITERATOR;
    }

    public Iterator getMapArcProperties() {
        Iterator it = null;
        if (this.getSuperclassDescriptor() != null) {
            it = this.getSuperclassDescriptor().getMapArcProperties();
        }
        if (this.declaredMapArcProperties != null) {
            it = it != null ? IteratorUtils.chainedIterator(it, this.declaredMapArcProperties.iterator()) : this.declaredMapArcProperties.iterator();
        }
        return it != null ? it : IteratorUtils.EMPTY_ITERATOR;
    }

    public Property getProperty(String propertyName) {
        Property property = this.getDeclaredProperty(propertyName);
        if (property == null && this.superclassDescriptor != null) {
            property = this.superclassDescriptor.getProperty(propertyName);
        }
        return property;
    }

    public Property getDeclaredProperty(String propertyName) {
        return (Property)this.declaredProperties.get(propertyName);
    }

    public ClassDescriptor getSuperclassDescriptor() {
        return this.superclassDescriptor;
    }

    public Object createObject() {
        if (this.objectClass == null) {
            throw new NullPointerException("Null objectClass. Descriptor wasn't initialized properly.");
        }
        try {
            return this.objectClass.newInstance();
        }
        catch (Throwable e) {
            throw new CayenneRuntimeException("Error creating object of class '" + this.objectClass.getName() + "'", e);
        }
    }

    public void injectValueHolders(Object object) throws PropertyException {
        if (this.getSuperclassDescriptor() != null) {
            this.getSuperclassDescriptor().injectValueHolders(object);
        }
        Iterator it = this.declaredProperties.values().iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            property.injectValueHolder(object);
        }
    }

    public void shallowMerge(final Object from, final Object to) throws PropertyException {
        this.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                property.writePropertyDirectly(to, property.readPropertyDirectly(to), property.readPropertyDirectly(from));
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                property.invalidate(to);
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }
        });
    }

    public boolean visitDeclaredProperties(PropertyVisitor visitor) {
        Iterator it = this.declaredProperties.values().iterator();
        while (it.hasNext()) {
            Property next = (Property)it.next();
            if (next.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    public boolean visitAllProperties(PropertyVisitor visitor) {
        if (!this.visitProperties(visitor)) {
            return false;
        }
        if (!this.subclassDescriptors.isEmpty()) {
            Iterator it = this.subclassDescriptors.values().iterator();
            while (it.hasNext()) {
                ClassDescriptor next = (ClassDescriptor)it.next();
                if (next.visitDeclaredProperties(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean visitProperties(PropertyVisitor visitor) {
        if (this.superclassDescriptor != null && !this.superclassDescriptor.visitProperties(visitor)) {
            return false;
        }
        return this.visitDeclaredProperties(visitor);
    }

    public void setPersistenceStateAccessor(Accessor persistenceStateAccessor) {
        this.persistenceStateAccessor = persistenceStateAccessor;
    }

    public void setEntity(ObjEntity entity) {
        this.entity = entity;
    }

    public void setSuperclassDescriptor(ClassDescriptor superclassDescriptor) {
        this.superclassDescriptor = superclassDescriptor;
    }
}

