/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.conf.EntityMapAnnotationLoader;
import org.apache.cayenne.jpa.conf.EntityMapDefaultsProcessor;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.conf.EntityMapMergeProcessor;
import org.apache.cayenne.jpa.conf.EntityMapXMLLoader;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.map.JpaEntityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMapLoader {
    static final String DESCRIPTOR_LOCATION = "META-INF/orm.xml";
    protected EntityMapLoaderContext context;
    protected Map<String, JpaClassDescriptor> descriptors;

    public EntityMapLoader(PersistenceUnitInfo persistenceUnit) {
        this.loadEntityMap(persistenceUnit);
    }

    public JpaEntityMap getEntityMap() {
        return this.context.getEntityMap();
    }

    public EntityMapLoaderContext getContext() {
        return this.context;
    }

    protected void loadEntityMap(PersistenceUnitInfo persistenceUnit) throws JpaProviderException {
        this.context = new EntityMapLoaderContext(persistenceUnit);
        try {
            this.loadFromAnnotations(persistenceUnit);
            this.updateFromXML(persistenceUnit);
            this.updateFromDefaults();
        }
        catch (JpaProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JpaProviderException("Error loading ORM descriptors", e);
        }
    }

    protected void updateFromDefaults() {
        new EntityMapDefaultsProcessor().applyDefaults(this.context);
    }

    protected void updateFromXML(PersistenceUnitInfo unit) throws IOException {
        EntityMapMergeProcessor merger = new EntityMapMergeProcessor(this.context);
        HashSet<String> loadedLocations = new HashSet<String>();
        EntityMapXMLLoader loader = new EntityMapXMLLoader(this.context.getTempClassLoader(), false);
        loadedLocations.add(DESCRIPTOR_LOCATION);
        Enumeration<URL> standardDescriptors = this.context.getTempClassLoader().getResources(DESCRIPTOR_LOCATION);
        while (standardDescriptors.hasMoreElements()) {
            JpaEntityMap map = loader.getEntityMap(standardDescriptors.nextElement());
            merger.mergeOverride(map);
        }
        for (String descriptor : unit.getMappingFileNames()) {
            if (!loadedLocations.add(descriptor)) continue;
            Enumeration<URL> mappedDescriptors = this.context.getTempClassLoader().getResources(descriptor);
            while (mappedDescriptors.hasMoreElements()) {
                JpaEntityMap map = loader.getEntityMap(mappedDescriptors.nextElement());
                merger.mergeOverride(map);
            }
        }
    }

    protected void loadFromAnnotations(PersistenceUnitInfo persistenceUnit) {
        HashMap managedClassMap = new HashMap();
        ClassLoader loader = this.context.getTempClassLoader();
        List explicitClasses = persistenceUnit.getManagedClassNames();
        if (explicitClasses != null) {
            for (String className : explicitClasses) {
                Class managedClass;
                try {
                    managedClass = Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new JpaProviderException("Class not found: " + className, e);
                }
                managedClassMap.put(className, managedClass);
            }
        }
        if (!persistenceUnit.excludeUnlistedClasses()) {
            Collection<String> implicitClasses = this.listImplicitClasses(persistenceUnit);
            for (String className : implicitClasses) {
                Class<?> managedClass;
                if (managedClassMap.containsKey(className)) continue;
                try {
                    managedClass = Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new JpaProviderException("Class not found: " + className, e);
                }
                if (managedClass.getAnnotation(Entity.class) == null && managedClass.getAnnotation(MappedSuperclass.class) == null && managedClass.getAnnotation(Embeddable.class) == null) continue;
                managedClassMap.put(className, managedClass);
            }
        }
        if (!managedClassMap.isEmpty()) {
            EntityMapAnnotationLoader annotationLoader = new EntityMapAnnotationLoader(this.context);
            for (Class managedClass : managedClassMap.values()) {
                annotationLoader.loadClassMapping(managedClass);
            }
        }
    }

    protected Collection<String> listImplicitClasses(PersistenceUnitInfo persistenceUnit) {
        ArrayList<String> classes = new ArrayList<String>();
        URL rootURL = persistenceUnit.getPersistenceUnitRootUrl();
        if (rootURL != null) {
            if ("file".equals(rootURL.getProtocol())) {
                this.locateClassesInFolder(rootURL, classes);
            } else {
                this.locateClassesInJar(rootURL, classes);
            }
        }
        for (URL jarURL : persistenceUnit.getJarFileUrls()) {
            if (jarURL == null) continue;
            if ("file".equals(jarURL.getProtocol())) {
                this.locateClassesInFolder(jarURL, classes);
                continue;
            }
            this.locateClassesInJar(jarURL, classes);
        }
        return classes;
    }

    private void locateClassesInFolder(URL dirURL, Collection<String> classes) {
        File root;
        try {
            root = new File(dirURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new JpaProviderException("Error converting url to file: " + dirURL, e);
        }
        this.locateClassesInFolder(root, root.getAbsolutePath().length() + 1, classes);
    }

    private void locateClassesInFolder(File folder, int rootPathLength, Collection<String> classes) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.locateClassesInFolder(files[i], rootPathLength, classes);
                    continue;
                }
                String name = files[i].getName();
                if (!name.endsWith(".class")) continue;
                int suffixLen = ".class".length();
                String absPath = files[i].getAbsolutePath();
                if (absPath.length() <= rootPathLength + suffixLen) continue;
                classes.add(absPath.substring(rootPathLength, absPath.length() - suffixLen).replace('/', '.'));
            }
        }
    }

    private void locateClassesInJar(URL jarURL, Collection<String> classes) {
        try {
            JarURLConnection connection = (JarURLConnection)jarURL.openConnection();
            JarFile jar = connection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry e = entries.nextElement();
                if (e.isDirectory() || !(name = e.getName()).endsWith(".class")) continue;
                int suffixLen = ".class".length();
                classes.add(name.substring(0, name.length() - suffixLen).replace('/', '.'));
            }
        }
        catch (Exception e) {
            throw new JpaProviderException("Error reading jar contents: " + jarURL, e);
        }
    }
}

