/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.enhancer.EnhancerVisitorFactory;
import org.apache.cayenne.enhancer.PersistentAccessorVisitor;
import org.apache.cayenne.enhancer.PersistentInterfaceVisitor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;

public class CayenneEnhancerVisitorFactory
implements EnhancerVisitorFactory {
    protected Map<String, ObjEntity> entitiesByClass;

    public CayenneEnhancerVisitorFactory(EntityResolver entityResolver) {
        this.indexEntities(entityResolver);
    }

    protected void indexEntities(EntityResolver entityResolver) {
        this.entitiesByClass = new HashMap<String, ObjEntity>();
        for (Object object : entityResolver.getObjEntities()) {
            ObjEntity entity = (ObjEntity)object;
            this.entitiesByClass.put(entity.getClassName(), entity);
        }
    }

    public ClassVisitor createVisitor(String className, ClassVisitor out) {
        ObjEntity entity = this.entitiesByClass.get(className.replace('/', '.'));
        if (entity == null) {
            return null;
        }
        PersistentInterfaceVisitor e1 = new PersistentInterfaceVisitor(out);
        PersistentAccessorVisitor e2 = new PersistentAccessorVisitor((ClassVisitor)e1, entity);
        SerialVersionUIDAdder e3 = new SerialVersionUIDAdder((ClassVisitor)e2);
        return e3;
    }
}

