/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.AbstractType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

public class EnumType
implements ExtendedType {
    protected Class enumClass;
    protected Object[] values;

    public EnumType(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Null enum class");
        }
        this.enumClass = enumClass;
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            this.values = (Object[])m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + enumClass.getName() + " is not an Enum", e);
        }
    }

    public String getClassName() {
        return this.enumClass.getName();
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return AbstractType.validateNull(source, property, value, dbAttribute, validationResult);
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            if (TypesMapping.isNumeric(type)) {
                statement.setInt(pos, e.ordinal());
            } else {
                statement.setString(pos, e.name());
            }
        } else {
            statement.setNull(pos, type);
        }
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : this.values[i];
        }
        String string = rs.getString(index);
        return string != null ? Enum.valueOf(this.enumClass, string) : null;
    }

    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : this.values[i];
        }
        String string = rs.getString(index);
        return string != null ? Enum.valueOf(this.enumClass, string) : null;
    }
}

