/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.reflect.ClassDescriptor;

public class EJBQLTranslationContext {
    private Map tableAliases;
    private Map boundParameters;
    private StringBuffer mainBuffer;
    private StringBuffer currentBuffer;
    private EJBQLCompiledExpression compiledExpression;
    private Map attributes;
    private Map reusableJoins;
    private Map parameters;
    private Map idAliases;
    private int columnAliasPosition;
    private EJBQLTranslatorFactory translatorFactory;
    private boolean usingAliases;
    private boolean appendingResultColumns;

    public EJBQLTranslationContext(EJBQLCompiledExpression compiledExpression, Map parameters, EJBQLTranslatorFactory translatorFactory) {
        this.compiledExpression = compiledExpression;
        this.currentBuffer = this.mainBuffer = new StringBuffer();
        this.parameters = parameters;
        this.translatorFactory = translatorFactory;
        this.usingAliases = true;
    }

    SQLTemplate getQuery() {
        String sql = this.mainBuffer.length() > 0 ? this.mainBuffer.toString() : null;
        SQLTemplate query = new SQLTemplate(this.compiledExpression.getRootDescriptor().getObjectClass(), sql);
        query.setParameters(this.boundParameters);
        return query;
    }

    private String resolveId(String id) {
        if (this.idAliases == null) {
            return id;
        }
        String resolvedAlias = (String)this.idAliases.get(id);
        if (resolvedAlias != null) {
            return resolvedAlias;
        }
        return id;
    }

    EJBQLTranslatorFactory getTranslatorFactory() {
        return this.translatorFactory;
    }

    public ClassDescriptor getEntityDescriptor(String id) {
        return this.compiledExpression.getEntityDescriptor(this.resolveId(id));
    }

    ObjRelationship getIncomingRelationship(String id) {
        return this.compiledExpression.getIncomingRelationship(this.resolveId(id));
    }

    String createIdAlias(String id) {
        if (this.idAliases == null) {
            this.idAliases = new HashMap();
        }
        for (int i = 0; i < 1000; ++i) {
            String alias = id + "_alias" + i;
            if (this.idAliases.containsKey(alias) || this.compiledExpression.getEntityDescriptor(alias) != null) continue;
            this.idAliases.put(alias, id);
            return alias;
        }
        throw new EJBQLException("Failed to create id alias");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markCurrentPosition(String marker) {
        this.findOrCreateMarkedBuffer(marker);
        String internalMarker = (String)this.getAttribute(marker);
        StringBuffer current = this.currentBuffer;
        try {
            this.switchToMainBuffer();
            this.append("${").append(internalMarker).append("}");
        }
        finally {
            this.currentBuffer = current;
        }
    }

    void switchToMarker(String marker, boolean reset) {
        this.currentBuffer = this.findOrCreateMarkedBuffer(marker);
        if (reset) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
        }
    }

    void switchToMainBuffer() {
        this.currentBuffer = this.mainBuffer;
    }

    private StringBuffer findOrCreateMarkedBuffer(String marker) {
        StringBuffer buffer;
        String internalMarker = (String)this.getAttribute(marker);
        if (internalMarker == null) {
            buffer = new StringBuffer();
            internalMarker = this.bindParameter(buffer, "marker");
            this.setAttribute(marker, internalMarker);
        } else {
            Object object = this.boundParameters.get(internalMarker);
            if (!(object instanceof StringBuffer)) {
                throw new IllegalArgumentException("Invalid or missing buffer for marker: " + marker);
            }
            buffer = (StringBuffer)object;
        }
        return buffer;
    }

    Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    void setAttribute(String var, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(var, value);
    }

    public EJBQLTranslationContext append(String chunk) {
        this.currentBuffer.append(chunk);
        return this;
    }

    public EJBQLTranslationContext append(char chunk) {
        this.currentBuffer.append(chunk);
        return this;
    }

    EJBQLTranslationContext trim(int n) {
        int len = this.currentBuffer.length();
        if (len >= n) {
            this.currentBuffer.delete(len - n, len);
        }
        return this;
    }

    EJBQLCompiledExpression getCompiledExpression() {
        return this.compiledExpression;
    }

    String bindPositionalParameter(int position) {
        return this.bindParameter(this.parameters.get(new Integer(position)));
    }

    String bindNamedParameter(String name) {
        return this.bindParameter(this.parameters.get(name));
    }

    String bindParameter(Object value) {
        return this.bindParameter(value, "id");
    }

    void rebindParameter(String boundName, Object newValue) {
        this.boundParameters.put(boundName, newValue);
    }

    String bindParameter(Object value, String prefix) {
        if (this.boundParameters == null) {
            this.boundParameters = new HashMap();
        }
        String var = prefix + this.boundParameters.size();
        this.boundParameters.put(var, value);
        return var;
    }

    Object getBoundParameter(String name) {
        return this.boundParameters != null ? this.boundParameters.get(name) : null;
    }

    String registerReusableJoin(String sourceIdPath, String relationship, String targetId) {
        String key;
        String oldId;
        if (this.reusableJoins == null) {
            this.reusableJoins = new HashMap();
        }
        if ((oldId = this.reusableJoins.put(key = sourceIdPath + ":" + relationship, targetId)) != null) {
            this.reusableJoins.put(key, oldId);
            return oldId;
        }
        return null;
    }

    protected String getTableAlias(String idPath, String tableName) {
        String alias;
        if (!this.isUsingAliases()) {
            return tableName;
        }
        StringBuffer keyBuffer = new StringBuffer();
        int dot = idPath.indexOf(46);
        if (dot > 0) {
            keyBuffer.append(idPath.substring(0, dot).toLowerCase()).append(idPath.substring(dot));
        } else {
            keyBuffer.append(idPath.toLowerCase());
        }
        String key = keyBuffer.append(':').append(tableName).toString();
        if (this.tableAliases != null) {
            alias = (String)this.tableAliases.get(key);
        } else {
            this.tableAliases = new HashMap();
            alias = null;
        }
        if (alias == null) {
            alias = "t" + this.tableAliases.size();
            this.tableAliases.put(key, alias);
        }
        return alias;
    }

    String nextColumnAlias() {
        SQLResultSetMapping resultSetMapping = this.compiledExpression.getResultSetMapping();
        if (resultSetMapping == null) {
            throw new EJBQLException("No result set mapping exists for expression, can't map column aliases");
        }
        return (String)resultSetMapping.getColumnResults().get(this.columnAliasPosition++);
    }

    boolean isAppendingResultColumns() {
        return this.appendingResultColumns;
    }

    void setAppendingResultColumns(boolean appendingResultColumns) {
        this.appendingResultColumns = appendingResultColumns;
    }

    public boolean isUsingAliases() {
        return this.usingAliases;
    }

    public void setUsingAliases(boolean useAliases) {
        this.usingAliases = useAliases;
    }
}

