/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.reflect.ClassDescriptor;

class DataDomainInsertBucket
extends DataDomainSyncBucket {
    DataDomainInsertBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    void appendQueriesInternal(Collection queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, false);
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.descriptorsByDbEntity.get(dbEntity);
            InsertBatchQuery batch = new InsertBatchQuery(dbEntity, 27);
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ClassDescriptor descriptor = (ClassDescriptor)j.next();
                diffBuilder.reset(descriptor.getEntity(), dbEntity);
                boolean isMasterDbEntity = descriptor.getEntity().getDbEntity() == dbEntity;
                List objects = (List)(isMasterDbEntity ? this.objectsByDescriptor.get(descriptor) : this.objectsByDescriptor.remove(descriptor));
                if (objects.isEmpty()) continue;
                this.checkReadOnly(descriptor.getEntity());
                if (isMasterDbEntity) {
                    this.createPermIdsForObjEntity(descriptor, objects);
                    sorter.sortObjectsForEntity(descriptor.getEntity(), objects, false);
                }
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    Persistent o = (Persistent)k.next();
                    Map snapshot = diffBuilder.buildDBDiff(this.parent.objectDiff(o.getObjectId()));
                    batch.add(snapshot, o.getObjectId());
                }
            }
            queries.add(batch);
        }
    }

    void createPermIdsForObjEntity(ClassDescriptor descriptor, List dataObjects) {
        if (dataObjects.isEmpty()) {
            return;
        }
        ObjEntity objEntity = descriptor.getEntity();
        DbEntity dbEntity = objEntity.getDbEntity();
        DataNode node = this.parent.getDomain().lookupDataNode(dbEntity.getDataMap());
        boolean supportsGeneratedKeys = node.getAdapter().supportsGeneratedKeys();
        PkGenerator pkGenerator = node.getAdapter().getPkGenerator();
        Iterator i = dataObjects.iterator();
        while (i.hasNext()) {
            Persistent object = (Persistent)i.next();
            ObjectId id = object.getObjectId();
            if (id == null || !id.isTemporary()) continue;
            Map idMap = id.getReplacementIdMap();
            boolean autoPkDone = false;
            Iterator it = dbEntity.getPrimaryKey().iterator();
            while (it.hasNext()) {
                Class javaClass;
                Object value;
                DbAttribute dbAttr = (DbAttribute)it.next();
                String dbAttrName = dbAttr.getName();
                if (idMap.containsKey(dbAttrName)) continue;
                ObjAttribute objAttr = objEntity.getAttributeForDbAttribute(dbAttr);
                if (!(objAttr == null || (value = descriptor.getProperty(objAttr.getName()).readPropertyDirectly(object)) == null || (javaClass = objAttr.getJavaClass()).isPrimitive() && value instanceof Number && ((Number)value).intValue() == 0)) {
                    idMap.put(dbAttrName, value);
                    continue;
                }
                if (supportsGeneratedKeys && dbAttr.isGenerated() || this.isPropagated(dbAttr)) continue;
                if (autoPkDone) {
                    throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.");
                }
                try {
                    Object pkValue = pkGenerator.generatePkForDbEntity(node, dbEntity);
                    idMap.put(dbAttrName, pkValue);
                    autoPkDone = true;
                }
                catch (Exception ex) {
                    throw new CayenneRuntimeException("Error generating PK: " + ex.getMessage(), ex);
                }
            }
        }
    }

    boolean isPropagated(DbAttribute attribute) {
        Iterator it = attribute.getEntity().getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship dbRel = (DbRelationship)it.next();
            if (!dbRel.isToMasterPK()) continue;
            Iterator joins = dbRel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                if (!attribute.getName().equals(join.getSourceName())) continue;
                return true;
            }
        }
        return false;
    }
}

