/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import java.util.Collection;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptorFactory;
import org.apache.cayenne.reflect.pojo.EnhancedPojoToManyProperty;
import org.apache.cayenne.reflect.pojo.EnhancedPojoToOneProperty;

public class EnhancedPojoDescriptorFactory
extends PersistentDescriptorFactory {
    static final String PERSISTENCE_STATE_FIELD = "$cay_persistenceState";

    public EnhancedPojoDescriptorFactory(ClassDescriptorMap descriptorMap) {
        super(descriptorMap);
    }

    protected ClassDescriptor getDescriptor(ObjEntity entity, Class entityClass) {
        try {
            Integer.TYPE.equals(entityClass.getDeclaredField(PERSISTENCE_STATE_FIELD).getType());
        }
        catch (Throwable th) {
            return null;
        }
        return super.getDescriptor(entity, entityClass);
    }

    protected void createToManyProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Collection.class);
        descriptor.addDeclaredProperty(new EnhancedPojoToManyProperty(descriptor, targetDescriptor, accessor, reverseName));
    }

    protected void createToOneProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), targetDescriptor.getObjectClass());
        descriptor.addDeclaredProperty(new EnhancedPojoToOneProperty(descriptor, targetDescriptor, accessor, reverseName));
    }
}

