/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.util.Util;

class CallbackOnEntity
extends AbstractCallback {
    private Method callbackMethod;

    CallbackOnEntity(Class objectClass, String methodName) throws IllegalArgumentException {
        this.callbackMethod = this.findMethod(objectClass, methodName);
    }

    public void performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(entity, null);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking entity callback method " + this.callbackMethod.getName(), e);
        }
    }

    private Method findMethod(Class objectClass, String methodName) throws IllegalArgumentException {
        Method[] methods = objectClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            int modifiers;
            if (!methodName.equals(methods[i].getName()) || Modifier.isStatic(modifiers = methods[i].getModifiers()) || !Void.TYPE.isAssignableFrom(methods[i].getReturnType()) || methods[i].getParameterTypes().length != 0) continue;
            if (!Util.isAccessible(methods[i])) {
                methods[i].setAccessible(true);
            }
            return methods[i];
        }
        throw new IllegalArgumentException("Class " + objectClass.getName() + " has no valid callback method '" + methodName + "'");
    }
}

