/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.query.SQLTemplate;

class SQLTemplateMetadata
extends BaseQueryMetadata {
    private SQLResultSetMapping resultSetMapping;

    SQLTemplateMetadata() {
    }

    void setResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.resultSetMapping = resultSetMapping;
    }

    public SQLResultSetMapping getResultSetMapping() {
        return this.resultSetMapping;
    }

    boolean resolve(Object root, EntityResolver resolver, SQLTemplate query) {
        if (super.resolve(root, resolver, null)) {
            if (!"nocache".equals(this.getCachePolicy())) {
                if (query.getName() != null) {
                    this.cacheKey = query.getName();
                } else {
                    Map parameters;
                    StringBuffer key = new StringBuffer();
                    ObjEntity entity = this.getObjEntity();
                    if (entity != null) {
                        key.append(entity.getName());
                    } else if (this.dbEntity != null) {
                        key.append("db:").append(this.dbEntity.getName());
                    }
                    if (query.getDefaultTemplate() != null) {
                        key.append('/').append(query.getDefaultTemplate());
                    }
                    if (!(parameters = query.getParameters()).isEmpty()) {
                        ArrayList keys = new ArrayList(parameters.keySet());
                        Collections.sort(keys);
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            Object parameterKey = it.next();
                            key.append('/').append(parameterKey).append('=').append(parameters.get(parameterKey));
                        }
                    }
                    this.cacheKey = key.toString();
                }
            }
            return true;
        }
        return false;
    }
}

