/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class Procedure
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    protected String name;
    protected DataMap dataMap;
    protected String catalog;
    protected String schema;
    protected boolean returningValue;
    protected List callParameters = new ArrayList();

    public Procedure() {
    }

    public Procedure(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getParent() {
        return this.getDataMap();
    }

    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof DataMap)) {
            throw new IllegalArgumentException("Expected null or DataMap, got: " + parent);
        }
        this.setDataMap((DataMap)parent);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<procedure name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print('\"');
        if (this.getSchema() != null && this.getSchema().trim().length() > 0) {
            encoder.print(" schema=\"");
            encoder.print(this.getSchema().trim());
            encoder.print('\"');
        }
        if (this.getCatalog() != null && this.getCatalog().trim().length() > 0) {
            encoder.print(" catalog=\"");
            encoder.print(this.getCatalog().trim());
            encoder.print('\"');
        }
        if (this.isReturningValue()) {
            encoder.print(" returningValue=\"true\"");
        }
        encoder.println('>');
        encoder.indent(1);
        encoder.print(this.getCallParameters());
        encoder.indent(-1);
        encoder.println("</procedure>");
    }

    public String getFullyQualifiedName() {
        return this.schema != null ? this.schema + '.' + this.getName() : this.getName();
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void setCallParameters(List parameters) {
        this.clearCallParameters();
        this.callParameters.addAll(parameters);
    }

    public void addCallParameter(ProcedureParameter param) {
        if (param.getName() == null) {
            throw new IllegalArgumentException("Attempt to add unnamed parameter.");
        }
        if (this.callParameters.contains(param)) {
            throw new IllegalArgumentException("Attempt to add the same parameter more than once:" + param);
        }
        param.setProcedure(this);
        this.callParameters.add(param);
    }

    public void removeCallParameter(String name) {
        for (int i = 0; i < this.callParameters.size(); ++i) {
            ProcedureParameter nextParam = (ProcedureParameter)this.callParameters.get(i);
            if (!name.equals(nextParam.getName())) continue;
            this.callParameters.remove(i);
            break;
        }
    }

    public void clearCallParameters() {
        this.callParameters.clear();
    }

    public List getCallParameters() {
        return Collections.unmodifiableList(this.callParameters);
    }

    public List getCallOutParameters() {
        ArrayList<ProcedureParameter> outParams = new ArrayList<ProcedureParameter>(this.callParameters.size());
        Iterator it = this.callParameters.iterator();
        while (it.hasNext()) {
            ProcedureParameter param = (ProcedureParameter)it.next();
            if (!param.isOutParam()) continue;
            outParams.add(param);
        }
        return outParams;
    }

    public ProcedureParameter getResultParam() {
        return this.returningValue && this.callParameters.size() > 0 ? (ProcedureParameter)this.callParameters.get(0) : null;
    }

    public boolean isReturningValue() {
        return this.returningValue;
    }

    public void setReturningValue(boolean returningValue) {
        this.returningValue = returningValue;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }
}

