/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.commons.collections.Transformer;

public class DbEntity
extends Entity
implements DbEntityListener,
DbAttributeListener,
DbRelationshipListener {
    protected String catalog;
    protected String schema;
    protected List primaryKey = new ArrayList(2);
    protected Collection generatedAttributes = new ArrayList(2);
    protected DbKeyGenerator primaryKeyGenerator;

    public DbEntity() {
    }

    public DbEntity(String name) {
        this();
        this.setName(name);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-entity name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print('\"');
        if (this.getSchema() != null && this.getSchema().trim().length() > 0) {
            encoder.print(" schema=\"");
            encoder.print(Util.encodeXmlAttribute(this.getSchema().trim()));
            encoder.print('\"');
        }
        if (this.getCatalog() != null && this.getCatalog().trim().length() > 0) {
            encoder.print(" catalog=\"");
            encoder.print(Util.encodeXmlAttribute(this.getCatalog().trim()));
            encoder.print('\"');
        }
        encoder.println('>');
        encoder.indent(1);
        encoder.print(this.getAttributeMap());
        if (this.getPrimaryKeyGenerator() != null) {
            this.getPrimaryKeyGenerator().encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</db-entity>");
    }

    public String getFullyQualifiedName() {
        return this.schema != null ? this.schema + '.' + this.getName() : this.getName();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public List getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    public Collection getGeneratedAttributes() {
        return Collections.unmodifiableCollection(this.generatedAttributes);
    }

    public void addAttribute(Attribute attr) {
        super.addAttribute(attr);
        this.dbAttributeAdded(new AttributeEvent((Object)this, attr, (Entity)this, 2));
    }

    public void removeAttribute(String attrName) {
        Attribute attr = this.getAttribute(attrName);
        if (attr == null) {
            return;
        }
        DataMap map = this.getDataMap();
        if (map != null) {
            Iterator ents = map.getDbEntities().iterator();
            while (ents.hasNext()) {
                DbEntity ent = (DbEntity)ents.next();
                Iterator it = ent.getRelationships().iterator();
                while (it.hasNext()) {
                    DbRelationship rel = (DbRelationship)it.next();
                    Iterator joins = rel.getJoins().iterator();
                    while (joins.hasNext()) {
                        DbJoin join = (DbJoin)joins.next();
                        if (join.getSource() != attr && join.getTarget() != attr) continue;
                        joins.remove();
                    }
                }
            }
        }
        super.removeAttribute(attrName);
        this.dbAttributeRemoved(new AttributeEvent((Object)this, attr, (Entity)this, 3));
    }

    public void clearAttributes() {
        super.clearAttributes();
        this.dbAttributeRemoved(new AttributeEvent((Object)this, null, (Entity)this, 3));
    }

    public Iterator resolvePathComponents(Expression pathExp) throws ExpressionException {
        if (pathExp.getType() != 27) {
            throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  DB_PATH is expected.");
        }
        return new Entity.PathIterator(this, (String)pathExp.getOperand(0));
    }

    public void setPrimaryKeyGenerator(DbKeyGenerator primaryKeyGenerator) {
        this.primaryKeyGenerator = primaryKeyGenerator;
        if (primaryKeyGenerator != null) {
            primaryKeyGenerator.setDbEntity(this);
        }
    }

    public DbKeyGenerator getPrimaryKeyGenerator() {
        return this.primaryKeyGenerator;
    }

    public void dbEntityChanged(EntityEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        if (e.getId() == 1 && e.isNameChange()) {
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                Iterator ents = map.getDbEntities().iterator();
                while (ents.hasNext()) {
                    DbEntity dbe = (DbEntity)ents.next();
                    Iterator rit = dbe.getRelationships().iterator();
                    while (rit.hasNext()) {
                        DbRelationship rel = (DbRelationship)rit.next();
                        if (rel.getTargetEntity() != this) continue;
                        rel.setTargetEntityName(newName);
                    }
                }
                ents = map.getMappedEntities(this).iterator();
                while (ents.hasNext()) {
                    ObjEntity oe = (ObjEntity)ents.next();
                    if (oe.getDbEntity() != this) continue;
                    oe.setDbEntityName(newName);
                }
            }
        }
    }

    public void dbEntityAdded(EntityEvent e) {
    }

    public void dbEntityRemoved(EntityEvent e) {
    }

    public void dbAttributeAdded(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    public void dbAttributeChanged(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    public void dbAttributeRemoved(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    private void handleAttributeUpdate(AttributeEvent e) {
        DbAttribute dba;
        Iterator it;
        if (e == null || e.getEntity() != this) {
            return;
        }
        Attribute attr = e.getAttribute();
        if (attr == null && this.attributes.isEmpty()) {
            this.primaryKey.clear();
            this.generatedAttributes.clear();
            return;
        }
        if (!(attr instanceof DbAttribute)) {
            return;
        }
        DbAttribute dbAttr = (DbAttribute)attr;
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                Iterator ents = map.getDbEntities().iterator();
                while (ents.hasNext()) {
                    DbEntity ent = (DbEntity)ents.next();
                    Iterator it2 = map.getMappedEntities(ent).iterator();
                    while (it2.hasNext()) {
                        ObjEntity oe = (ObjEntity)it2.next();
                        Iterator ait = oe.getAttributes().iterator();
                        while (ait.hasNext()) {
                            ObjAttribute oa = (ObjAttribute)ait.next();
                            if (oa.getDbAttribute() != dbAttr) continue;
                            oa.setDbAttributeName(newName);
                        }
                    }
                    it2 = ent.getRelationships().iterator();
                    while (it2.hasNext()) {
                        DbRelationship rel = (DbRelationship)it2.next();
                        Iterator joins = rel.getJoins().iterator();
                        while (joins.hasNext()) {
                            DbJoin join = (DbJoin)joins.next();
                            if (join.getSource() == dbAttr) {
                                join.setSourceName(newName);
                            }
                            if (join.getTarget() != dbAttr) continue;
                            join.setTargetName(newName);
                        }
                    }
                }
            }
            this.attributes.remove(oldName);
            super.addAttribute(dbAttr);
        }
        if (this.primaryKey.contains(dbAttr) || dbAttr.isPrimaryKey()) {
            switch (e.getId()) {
                case 2: {
                    this.primaryKey.add(attr);
                    break;
                }
                case 3: {
                    this.primaryKey.remove(attr);
                    break;
                }
                default: {
                    this.primaryKey.clear();
                    it = this.getAttributes().iterator();
                    while (it.hasNext()) {
                        dba = (DbAttribute)it.next();
                        if (!dba.isPrimaryKey()) continue;
                        this.primaryKey.add(dba);
                    }
                    break block0;
                }
            }
        }
        if (this.generatedAttributes.contains(dbAttr) || dbAttr.isGenerated()) {
            switch (e.getId()) {
                case 2: {
                    this.generatedAttributes.add(attr);
                    break;
                }
                case 3: {
                    this.generatedAttributes.remove(attr);
                    break;
                }
                default: {
                    this.generatedAttributes.clear();
                    it = this.getAttributes().iterator();
                    while (it.hasNext()) {
                        dba = (DbAttribute)it.next();
                        if (!dba.isGenerated()) continue;
                        this.generatedAttributes.add(dba);
                    }
                    break block4;
                }
            }
        }
    }

    public void dbRelationshipChanged(RelationshipEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        Relationship rel = e.getRelationship();
        if (!(rel instanceof DbRelationship)) {
            return;
        }
        DbRelationship dbRel = (DbRelationship)rel;
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                Iterator ents = map.getObjEntities().iterator();
                while (ents.hasNext()) {
                    ObjEntity oe = (ObjEntity)ents.next();
                    Iterator rit = oe.getRelationships().iterator();
                    while (rit.hasNext()) {
                        ObjRelationship or = (ObjRelationship)rit.next();
                        if (!Util.nullSafeEquals(or.getDbRelationshipPath(), oldName)) continue;
                        or.setDbRelationshipPath(newName);
                    }
                }
            }
            this.relationships.remove(oldName);
            super.addRelationship(dbRel);
        }
    }

    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    public void dbRelationshipRemoved(RelationshipEvent e) {
    }

    public boolean isFullReplacementIdAttached(ObjectId id) {
        if (!id.isReplacementIdAttached()) {
            return false;
        }
        Map replacement = id.getReplacementIdMap();
        List pk = this.getPrimaryKey();
        if (pk.size() != replacement.size()) {
            return false;
        }
        Iterator it = pk.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            if (replacement.containsKey(attribute.getName())) continue;
            return false;
        }
        return true;
    }

    public Expression translateToRelatedEntity(Expression expression, String relationshipPath) {
        if (expression == null) {
            return null;
        }
        if (relationshipPath == null) {
            return expression;
        }
        return expression.transform(new RelationshipPathConverter(relationshipPath));
    }

    final class RelationshipPathConverter
    implements Transformer {
        String relationshipPath;

        RelationshipPathConverter(String relationshipPath) {
            this.relationshipPath = relationshipPath;
        }

        public Object transform(Object input) {
            if (!(input instanceof Expression)) {
                return input;
            }
            Expression expression = (Expression)input;
            if (expression.getType() != 27) {
                return input;
            }
            String path = (String)expression.getOperand(0);
            String converted = this.translatePath(path);
            Expression transformed = ExpressionFactory.expressionOfType(27);
            transformed.setOperand(0, converted);
            return transformed;
        }

        String translatePath(String path) {
            CayenneMapEntry next;
            DbRelationship nextDBR;
            if (path.equals(this.relationshipPath)) {
                LinkedList finalPath = new LinkedList();
                Iterator it = DbEntity.this.resolvePathComponents(path);
                DbRelationship lastDBR = null;
                while (it.hasNext()) {
                    lastDBR = (DbRelationship)it.next();
                }
                if (lastDBR != null) {
                    this.prependReversedPath(finalPath, lastDBR);
                    this.appendPath(finalPath, lastDBR);
                }
                return this.convertToPath(finalPath);
            }
            String relationshipPathWithDot = this.relationshipPath + ".";
            if (path.startsWith(relationshipPathWithDot)) {
                return path.substring(relationshipPathWithDot.length());
            }
            Iterator pathIt = DbEntity.this.resolvePathComponents(path);
            Iterator relationshipIt = DbEntity.this.resolvePathComponents(this.relationshipPath);
            LinkedList finalPath = new LinkedList();
            if (relationshipIt.hasNext() && pathIt.hasNext() && (nextDBR = (DbRelationship)relationshipIt.next()) != (next = (CayenneMapEntry)pathIt.next())) {
                this.prependReversedPath(finalPath, nextDBR);
                this.appendPath(finalPath, next);
            }
            while (relationshipIt.hasNext()) {
                nextDBR = (DbRelationship)relationshipIt.next();
                this.prependReversedPath(finalPath, nextDBR);
            }
            while (pathIt.hasNext()) {
                CayenneMapEntry next2 = (CayenneMapEntry)pathIt.next();
                this.appendPath(finalPath, next2);
            }
            return this.convertToPath(finalPath);
        }

        private String convertToPath(List path) {
            StringBuffer converted = new StringBuffer();
            int len = path.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    converted.append(".");
                }
                converted.append(path.get(i));
            }
            return converted.toString();
        }

        private void prependReversedPath(LinkedList finalPath, DbRelationship relationship) {
            DbRelationship revNextDBR = relationship.getReverseRelationship();
            if (revNextDBR == null) {
                throw new CayenneRuntimeException("Unable to find reverse DbRelationship for " + relationship.getSourceEntity().getName() + "." + relationship.getName() + ".");
            }
            finalPath.addFirst(revNextDBR.getName());
        }

        private void appendPath(LinkedList finalPath, CayenneMapEntry pathComponent) {
            finalPath.addLast(pathComponent.getName());
        }
    }
}

