/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.Basic;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.util.TreeNodeChild;

public class JpaBasic
extends JpaAttribute {
    protected FetchType fetch = FetchType.EAGER;
    protected boolean optional;
    protected JpaColumn column;
    protected boolean lob;
    protected TemporalType temporal;
    protected EnumType enumerated;

    public JpaBasic() {
    }

    public JpaBasic(Basic basic) {
        this.fetch = basic.fetch();
        this.optional = basic.optional();
    }

    public int getDefaultJdbcType() {
        if (this.getTemporal() != null) {
            if (TemporalType.TIMESTAMP == this.getTemporal()) {
                return 93;
            }
            if (TemporalType.DATE == this.getTemporal()) {
                return 91;
            }
            return 92;
        }
        if (this.getEnumerated() != null) {
            return this.getEnumerated() == EnumType.ORDINAL ? 4 : 12;
        }
        return TypesMapping.getSqlTypeByJava(this.getPropertyDescriptor().getType());
    }

    public FetchType getFetch() {
        return this.fetch;
    }

    public void setFetch(FetchType fetchType) {
        this.fetch = fetchType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @TreeNodeChild
    public JpaColumn getColumn() {
        return this.column;
    }

    public void setColumn(JpaColumn column) {
        this.column = column;
    }

    public EnumType getEnumerated() {
        return this.enumerated;
    }

    public void setEnumerated(EnumType enumerated) {
        this.enumerated = enumerated;
    }

    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean lob) {
        this.lob = lob;
    }

    public void setLobTrue(Object value) {
        this.setLob(true);
    }

    public TemporalType getTemporal() {
        return this.temporal;
    }

    public void setTemporal(TemporalType temporal) {
        this.temporal = temporal;
    }
}

