/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.conf.EntityMapAnnotationLoader;
import org.apache.cayenne.jpa.conf.EntityMapDefaultsProcessor;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.conf.EntityMapMergeProcessor;
import org.apache.cayenne.jpa.conf.EntityMapXMLLoader;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.map.JpaEntityMap;

public class EntityMapLoader {
    static final String DESCRIPTOR_LOCATION = "META-INF/orm.xml";
    protected EntityMapLoaderContext context;
    protected Map<String, JpaClassDescriptor> descriptors;

    public EntityMapLoader(PersistenceUnitInfo persistenceUnit) {
        this.loadEntityMap(persistenceUnit);
    }

    public JpaEntityMap getEntityMap() {
        return this.context.getEntityMap();
    }

    protected void loadEntityMap(PersistenceUnitInfo persistenceUnit) throws JpaProviderException {
        this.context = new EntityMapLoaderContext(persistenceUnit);
        try {
            this.loadFromAnnotations(persistenceUnit);
            this.updateFromXML(persistenceUnit);
            this.updateFromDefaults();
        }
        catch (JpaProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JpaProviderException("Error loading ORM descriptors", e);
        }
    }

    protected void updateFromDefaults() {
        new EntityMapDefaultsProcessor().applyDefaults(this.context);
    }

    protected void updateFromXML(PersistenceUnitInfo unit) throws IOException {
        EntityMapMergeProcessor merger = new EntityMapMergeProcessor(this.context);
        HashSet<String> loadedLocations = new HashSet<String>();
        EntityMapXMLLoader loader = new EntityMapXMLLoader(this.context.getTempClassLoader(), false);
        loadedLocations.add(DESCRIPTOR_LOCATION);
        Enumeration<URL> standardDescriptors = this.context.getTempClassLoader().getResources(DESCRIPTOR_LOCATION);
        while (standardDescriptors.hasMoreElements()) {
            JpaEntityMap map = loader.getEntityMap(standardDescriptors.nextElement());
            merger.mergeOverride(map);
        }
        for (String descriptor : unit.getMappingFileNames()) {
            if (!loadedLocations.add(descriptor)) continue;
            Enumeration<URL> mappedDescriptors = this.context.getTempClassLoader().getResources(descriptor);
            while (mappedDescriptors.hasMoreElements()) {
                JpaEntityMap map = loader.getEntityMap(mappedDescriptors.nextElement());
                merger.mergeOverride(map);
            }
        }
    }

    protected void loadFromAnnotations(PersistenceUnitInfo persistenceUnit) {
        if (!persistenceUnit.getManagedClassNames().isEmpty()) {
            ClassLoader loader = this.context.getTempClassLoader();
            EntityMapAnnotationLoader annotationLoader = new EntityMapAnnotationLoader(this.context);
            for (String className : persistenceUnit.getManagedClassNames()) {
                Class<?> managedClass;
                try {
                    managedClass = Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new JpaProviderException("Class not found: " + className, e);
                }
                annotationLoader.loadClassMapping(managedClass);
            }
        }
    }

    public EntityMapLoaderContext getContext() {
        return this.context;
    }
}

