/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TemporalType;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

public class JpaQuery
implements javax.persistence.Query {
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Query cayenneQuery;
    protected ObjectContext context;

    public JpaQuery(ObjectContext ctxt) {
        this.context = ctxt;
    }

    public JpaQuery(ObjectContext context, String name) {
        this(context);
        Query q = context.getEntityResolver().lookupQuery(name);
        if (q == null) {
            throw new IllegalArgumentException("Non-existing query: " + name);
        }
        this.setQuery(q);
    }

    protected void setQuery(Query q) {
        this.cayenneQuery = q;
    }

    protected Query getQuery() {
        return this.cayenneQuery;
    }

    private Query queryWithParameters() {
        if (this.parameters.size() == 0) {
            return this.cayenneQuery;
        }
        return ((ParameterizedQuery)this.cayenneQuery).createQuery(this.parameters);
    }

    public List getResultList() {
        return this.context.performQuery(this.queryWithParameters());
    }

    public int executeUpdate() {
        QueryResponse response = this.context.performGenericQuery(this.queryWithParameters());
        int[] res = response.firstUpdateCount();
        if (res == null) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < res.length; ++i) {
            num += res[i];
        }
        return num;
    }

    public Object getSingleResult() {
        List rows = this.getResultList();
        if (rows.size() == 0) {
            throw new NoResultException();
        }
        if (rows.size() > 1) {
            throw new NonUniqueResultException();
        }
        return rows.get(0);
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Invalid max results value: " + maxResult);
        }
        if (this.getQuery() instanceof SelectQuery) {
            ((SelectQuery)this.getQuery()).setFetchLimit(maxResult);
        } else if (this.getQuery() instanceof SQLTemplate) {
            ((SQLTemplate)this.getQuery()).setFetchLimit(maxResult);
        } else if (this.getQuery() instanceof ProcedureQuery) {
            ((ProcedureQuery)this.getQuery()).setFetchLimit(maxResult);
        }
        throw new IllegalArgumentException("query does not support maxResult");
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushModeType) {
        return this;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        return this;
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("Invalid first result value: " + startPosition);
        }
        throw new UnsupportedOperationException("TODO");
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        if (!(this.cayenneQuery instanceof ParameterizedQuery)) {
            throw new IllegalArgumentException("query does not accept parameters");
        }
        this.parameters.put(name, value);
        return this;
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(name, (Object)value);
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(name, (Object)value);
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        throw new UnsupportedOperationException("TODO");
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(position, (Object)value);
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(position, (Object)value);
    }
}

