/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.intercept;

import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.intercept.DataChannelDecorator;
import org.apache.cayenne.intercept.SyncCallbackProcessor;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;

public class DataChannelCallbackInterceptor
extends DataChannelDecorator {
    protected LifecycleCallbackRegistry callbackRegistry;
    protected boolean contextCallbacksEnabled;

    public void setChannel(DataChannel channel) {
        this.channel = channel;
        this.callbackRegistry = channel != null ? this.getEntityResolver().getCallbackRegistry() : null;
    }

    protected boolean isEmpty() {
        if (!(this.callbackRegistry.isEmpty(2) && this.callbackRegistry.isEmpty(3) && this.callbackRegistry.isEmpty(4) && this.callbackRegistry.isEmpty(5) && this.callbackRegistry.isEmpty(6))) {
            return false;
        }
        return this.contextCallbacksEnabled ? this.callbackRegistry.isEmpty(1) && this.callbackRegistry.isEmpty(0) : true;
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
        List list;
        QueryResponse response = this.channel.onQuery(originatingContext, query);
        if (!(this.callbackRegistry.isEmpty(6) || (list = response.firstList()) == null || list.isEmpty() || query.getMetaData(this.channel.getEntityResolver()).isFetchingDataRows())) {
            this.callbackRegistry.performCallbacks(6, list);
        }
        return response;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        if (this.isEmpty()) {
            return this.channel.onSync(originatingContext, changes, syncType);
        }
        SyncCallbackProcessor processor = this.createSyncProcessor(originatingContext.getGraphManager(), changes);
        processor.applyPreCommit(syncType);
        GraphDiff parentDiff = this.channel.onSync(originatingContext, changes, syncType);
        processor.applyPostCommit(syncType);
        return parentDiff;
    }

    SyncCallbackProcessor createSyncProcessor(GraphManager graphManager, GraphDiff changes) {
        return new SyncCallbackProcessor(this, graphManager, changes);
    }

    public boolean isContextCallbacksEnabled() {
        return this.contextCallbacksEnabled;
    }

    public void setContextCallbacksEnabled(boolean contextCallbacksEnabled) {
        this.contextCallbacksEnabled = contextCallbacksEnabled;
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        return this.callbackRegistry;
    }
}

