/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.Util;

public abstract class EventBridge
implements EventListener {
    public static final int RECEIVE_LOCAL = 1;
    public static final int RECEIVE_EXTERNAL = 2;
    public static final int RECEIVE_LOCAL_EXTERNAL = 3;
    protected String externalSubject;
    protected Collection localSubjects;
    protected EventManager eventManager;
    protected int mode;
    protected Object externalEventSource;
    Collection listeners;
    static /* synthetic */ Class class$org$apache$cayenne$event$CayenneEvent;

    public static String convertToExternalSubject(EventSubject localSubject) {
        char[] chars = localSubject.getSubjectName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' && chars[i] != '.') continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public EventBridge(EventSubject localSubject, String externalSubject) {
        this(Collections.singleton(localSubject), externalSubject);
    }

    public EventBridge(Collection localSubjects, String externalSubject) {
        this.localSubjects = new HashSet(localSubjects);
        this.externalSubject = externalSubject;
    }

    public String getExternalSubject() {
        return this.externalSubject;
    }

    public boolean isRunning() {
        return this.eventManager != null;
    }

    public Collection getLocalSubjects() {
        return this.localSubjects;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Object getExternalEventSource() {
        return this.externalEventSource != null ? this.externalEventSource : this;
    }

    public boolean receivesLocalEvents() {
        return this.mode == 3 || this.mode == 1;
    }

    public boolean receivesExternalEvents() {
        return this.mode == 3 || this.mode == 2;
    }

    public void startup(EventManager eventManager, int mode) throws Exception {
        this.startup(eventManager, mode, null);
    }

    public void startup(EventManager eventManager, int mode, Object localEventSource) throws Exception {
        this.startup(eventManager, mode, localEventSource, null);
    }

    public void startup(EventManager eventManager, int mode, Object localEventSource, Object remoteEventSource) throws Exception {
        if (eventManager == null) {
            throw new IllegalArgumentException("'eventManager' can't be null.");
        }
        if (this.eventManager != null) {
            this.shutdown();
        }
        this.externalEventSource = remoteEventSource;
        this.eventManager = eventManager;
        this.mode = mode;
        if (this.receivesLocalEvents() && !this.localSubjects.isEmpty()) {
            this.listeners = new ArrayList(this.localSubjects.size());
            Iterator it = this.localSubjects.iterator();
            while (it.hasNext()) {
                EventSubject subject = (EventSubject)it.next();
                SubjectListener listener = new SubjectListener(subject);
                this.listeners.add(listener);
                eventManager.addNonBlockingListener(listener, "onLocalEvent", class$org$apache$cayenne$event$CayenneEvent == null ? EventBridge.class$("org.apache.cayenne.event.CayenneEvent") : class$org$apache$cayenne$event$CayenneEvent, subject, localEventSource);
            }
        }
        this.startupExternal();
    }

    protected abstract void startupExternal() throws Exception;

    public void shutdown() throws Exception {
        this.externalEventSource = null;
        if (this.listeners != null && this.eventManager != null) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                SubjectListener listener = (SubjectListener)it.next();
                this.eventManager.removeListener(listener, listener.subject);
            }
            this.eventManager = null;
            this.listeners = null;
        }
        this.shutdownExternal();
    }

    protected abstract void shutdownExternal() throws Exception;

    protected void onExternalEvent(CayenneEvent event) {
        EventSubject localSubject;
        if (this.eventManager != null) {
            localSubject = event.getSubject();
            if (localSubject == null || !this.localSubjects.contains(localSubject)) {
                return;
            }
        } else {
            throw new IllegalStateException("Can't post events. EventBridge was not started properly. EventManager is null.");
        }
        event.setSource(this.getExternalEventSource());
        event.setPostedBy(this);
        this.eventManager.postEvent(event, localSubject);
    }

    protected abstract void sendExternalEvent(CayenneEvent var1) throws Exception;

    final class SubjectListener {
        EventSubject subject;

        SubjectListener(EventSubject subject) {
            this.subject = subject;
        }

        void onLocalEvent(CayenneEvent event) throws Exception {
            if (event.getSource() != EventBridge.this.getExternalEventSource() && event.getPostedBy() != EventBridge.this) {
                if (!this.subject.equals(event.getSubject())) {
                    CayenneEvent clone = (CayenneEvent)Util.cloneViaSerialization(event);
                    clone.setSubject(this.subject);
                    clone.setPostedBy(event.getPostedBy());
                    clone.setSource(event.getSource());
                    event = clone;
                }
                EventBridge.this.sendExternalEvent(event);
            }
        }
    }
}

