/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.postgres.PostgresActionBuilder;
import org.apache.cayenne.dba.postgres.PostgresByteArrayType;
import org.apache.cayenne.dba.postgres.PostgresPkGenerator;
import org.apache.cayenne.dba.postgres.PostgresQualifierTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DerivedDbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class PostgresAdapter
extends JdbcAdapter {
    public PostgresAdapter() {
        this.setSupportsBatchUpdates(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new PostgresActionBuilder(this, node.getEntityResolver()));
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new PostgresByteArrayType(true, true));
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        if ("bytea".equalsIgnoreCase(typeName)) {
            type = -4;
        } else if ("oid".equals(typeName)) {
            type = 2004;
        } else if ("text".equalsIgnoreCase(typeName)) {
            type = 2005;
        }
        return super.buildAttribute(name, typeName, type, size, scale, allowNulls);
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (this.typeSupportsLength(at.getType())) {
                int scale;
                int len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (at.isMandatory()) {
                buf.append(" NOT NULL");
                continue;
            }
            buf.append(" NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    private boolean typeSupportsLength(int type) {
        String[] externalTypes = this.externalTypesForJdbcType(type);
        if (externalTypes != null && externalTypes.length > 0) {
            for (int i = 0; i < externalTypes.length; ++i) {
                if (!"bytea".equalsIgnoreCase(externalTypes[i])) continue;
                return false;
            }
        }
        return TypesMapping.supportsLength(type);
    }

    public String dropTable(DbEntity ent) {
        return super.dropTable(ent) + " CASCADE";
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new PostgresQualifierTranslator(queryAssembler);
    }

    protected PkGenerator createPkGenerator() {
        return new PostgresPkGenerator();
    }
}

