/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DerivedDbEntity;

public class OpenBasePkGenerator
extends JdbcPkGenerator {
    public Object generatePkForDbEntity(DataNode node, DbEntity entity) throws Exception {
        byte[] binPK = this.binaryPK(entity);
        if (binPK != null) {
            return binPK;
        }
        return new Integer(this.pkFromDatabase(node, entity));
    }

    /*
     * Exception decompiling
     */
    protected int pkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String newIDString(DbEntity ent) {
        if (null == ent.getPrimaryKey() || 1 != ent.getPrimaryKey().size()) {
            throw new CayenneRuntimeException("Error generating pk for DbEntity " + ent.getName() + ": pk must be single attribute");
        }
        DbAttribute primaryKeyAttribute = (DbAttribute)ent.getPrimaryKey().get(0);
        StringBuffer buf = new StringBuffer("NEWID FOR ");
        buf.append(ent.getName()).append(' ').append(primaryKeyAttribute.getName());
        return buf.toString();
    }

    public void createAutoPk(DataNode node, List dbEntities) throws Exception {
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity entity = (DbEntity)it.next();
            if (!this.canCreatePK(entity)) continue;
            this.runUpdate(node, this.createPKString(entity));
            this.runUpdate(node, this.createUniquePKIndexString(entity));
        }
    }

    public List createAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>(2 * dbEntities.size());
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity entity = (DbEntity)it.next();
            if (!this.canCreatePK(entity)) continue;
            list.add(this.createPKString(entity));
            list.add(this.createUniquePKIndexString(entity));
        }
        return list;
    }

    protected boolean canCreatePK(DbEntity entity) {
        if (entity instanceof DerivedDbEntity) {
            return false;
        }
        List pk = entity.getPrimaryKey();
        return pk != null && pk.size() != 0;
    }

    public void dropAutoPk(DataNode node, List dbEntities) throws Exception {
    }

    public List dropAutoPkStatements(List dbEntities) {
        return Collections.EMPTY_LIST;
    }

    protected String createPKString(DbEntity entity) {
        List pk = entity.getPrimaryKey();
        if (pk == null || pk.size() == 0) {
            throw new CayenneRuntimeException("Entity '" + entity.getName() + "' has no PK defined.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE PRIMARY KEY ").append(entity.getName()).append(" (");
        Iterator it = pk.iterator();
        DbAttribute firstColumn = (DbAttribute)it.next();
        buffer.append(firstColumn.getName());
        while (it.hasNext()) {
            DbAttribute column = (DbAttribute)it.next();
            buffer.append(", ").append(column.getName());
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected String createUniquePKIndexString(DbEntity entity) {
        List pk = entity.getPrimaryKey();
        if (pk == null || pk.size() == 0) {
            throw new CayenneRuntimeException("Entity '" + entity.getName() + "' has no PK defined.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(pk.size() == 1 ? "CREATE UNIQUE INDEX " : "CREATE INDEX ").append(entity.getName()).append(" (");
        Iterator it = pk.iterator();
        DbAttribute firstColumn = (DbAttribute)it.next();
        buffer.append(firstColumn.getName());
        while (it.hasNext()) {
            DbAttribute column = (DbAttribute)it.next();
            buffer.append(", ").append(column.getName());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void reset() {
    }

    public int getPkCacheSize() {
        return 0;
    }

    public void setPkCacheSize(int pkCacheSize) {
    }
}

