/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.cayenne.dataview.CellRenderers;
import org.apache.cayenne.dataview.MapFormat;
import org.apache.cayenne.dataview.ObjEntityViewField;

public class FieldComponentFactory {
    public JComponent createFieldEditComponent(ObjEntityViewField field) {
        int alignment;
        CellRenderers cellRenderers = new CellRenderers();
        JComponent editor = null;
        Format format = field.getEditFormat();
        int dataType = field.getDataType().getValue();
        boolean lookup = field.isLookup();
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                alignment = 4;
                break;
            }
            default: {
                alignment = 2;
            }
        }
        if (lookup) {
            DefaultComboBoxModel<Object> comboData = new DefaultComboBoxModel<Object>(field.getLookupValues());
            ListCellRenderer comboRenderer = cellRenderers.createListCellRenderer(field);
            JComboBox<Object> comboBox = new JComboBox<Object>(comboData);
            comboBox.setRenderer(comboRenderer);
            editor = comboBox;
        } else if (format != null) {
            if (format instanceof MapFormat) {
                MapFormat mapFormat = (MapFormat)format;
                DefaultComboBoxModel<Object> comboData = new DefaultComboBoxModel<Object>(mapFormat.getValues());
                ListCellRenderer comboRenderer = cellRenderers.createFormatListCellRenderer(mapFormat, mapFormat.getNullFormat(), null, -1);
                JComboBox<Object> comboBox = new JComboBox<Object>(comboData);
                comboBox.setRenderer(comboRenderer);
                editor = comboBox;
            } else {
                JFormattedTextField textField = new JFormattedTextField(format);
                if (alignment >= 0) {
                    textField.setHorizontalAlignment(alignment);
                }
                if (format instanceof DecimalFormat) {
                    textField.setToolTipText(((DecimalFormat)format).toPattern());
                } else if (format instanceof SimpleDateFormat) {
                    textField.setToolTipText(((SimpleDateFormat)format).toPattern());
                }
                editor = textField;
            }
        } else if (dataType == 9) {
            JCheckBox checkBox;
            editor = checkBox = new JCheckBox();
        } else {
            JTextField textField = new JTextField();
            if (alignment >= 0) {
                textField.setHorizontalAlignment(alignment);
            }
            editor = textField;
        }
        return editor;
    }
}

