/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.cayenne.dataview.DataTypeEnum;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;

public class DataTypeSpec {
    protected Map dataTypeClassMap = new HashMap();
    protected Format dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    protected Format dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);

    public DataTypeSpec() {
        this.dataTypeClassMap.put(DataTypeEnum.BOOLEAN_TYPE, Boolean.class);
        this.dataTypeClassMap.put(DataTypeEnum.DATE_TYPE, java.util.Date.class);
        this.dataTypeClassMap.put(DataTypeEnum.DATETIME_TYPE, java.util.Date.class);
        this.dataTypeClassMap.put(DataTypeEnum.DOUBLE_TYPE, Double.class);
        this.dataTypeClassMap.put(DataTypeEnum.INTEGER_TYPE, Long.class);
        this.dataTypeClassMap.put(DataTypeEnum.MONEY_TYPE, Double.class);
        this.dataTypeClassMap.put(DataTypeEnum.PERCENT_TYPE, Double.class);
        this.dataTypeClassMap.put(DataTypeEnum.STRING_TYPE, String.class);
        this.dataTypeClassMap.put(DataTypeEnum.OBJECT_TYPE, Object.class);
        this.dataTypeClassMap.put(DataTypeEnum.UNKNOWN_TYPE, null);
    }

    public DataTypeEnum getDataType(String dataType) {
        return DataTypeEnum.getEnum(dataType);
    }

    public DataTypeEnum getDataType(int dataType) {
        return DataTypeEnum.getEnum(dataType);
    }

    public Class getJavaClass(DataTypeEnum dataType) {
        return (Class)this.dataTypeClassMap.get((Object)dataType);
    }

    public Object create(DataTypeEnum dataType) {
        Class clazz = this.getJavaClass(dataType);
        if (clazz != null) {
            try {
                Object value = clazz.newInstance();
                if (DataTypeEnum.DATE_TYPE.equals((Object)dataType)) {
                    value = DateUtils.truncate(value, (int)5);
                }
                return value;
            }
            catch (InstantiationException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public Object create(DataTypeEnum dataType, String argument) {
        Class clazz = this.getJavaClass(dataType);
        if (clazz != null) {
            try {
                if (DataTypeEnum.DATE_TYPE.equals((Object)dataType)) {
                    return this.dateFormat.parseObject(argument);
                }
                if (DataTypeEnum.DATETIME_TYPE.equals((Object)dataType)) {
                    return this.dateTimeFormat.parseObject(argument);
                }
                Constructor strConstructor = clazz.getConstructor(String.class);
                return strConstructor.newInstance(argument);
            }
            catch (ParseException ex) {
                return null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            catch (InstantiationException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public Object create(DataTypeEnum dataType, Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return this.create(dataType);
        }
        Class clazz = this.getJavaClass(dataType);
        if (clazz != null) {
            try {
                Class[] argTypes = new Class[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    argTypes[i] = arguments[i].getClass();
                }
                Constructor strConstructor = clazz.getConstructor(String.class);
                return strConstructor.newInstance(arguments);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            catch (InstantiationException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public Object toDataType(DataTypeEnum dataType, Object untypedValue) {
        Class dataTypeClass = this.getJavaClass(dataType);
        if (dataTypeClass == null || untypedValue == null || ClassUtils.isAssignable(untypedValue.getClass(), (Class)dataTypeClass)) {
            if (DataTypeEnum.DATE_TYPE.equals((Object)dataType) && java.util.Date.class.equals(dataTypeClass)) {
                return DateUtils.truncate((Object)untypedValue, (int)5);
            }
            return untypedValue;
        }
        Object v = null;
        String strUntypedValue = null;
        boolean isStringUntypedValue = untypedValue instanceof String;
        Number numUntypedValue = null;
        boolean isNumberUntypedValue = untypedValue instanceof Number;
        if (isStringUntypedValue) {
            strUntypedValue = (String)untypedValue;
        }
        if (isNumberUntypedValue) {
            numUntypedValue = (Number)untypedValue;
        }
        switch (dataType.getValue()) {
            case 9: {
                if (isNumberUntypedValue) {
                    v = BooleanUtils.toBooleanObject((int)numUntypedValue.intValue());
                    break;
                }
                if (!isStringUntypedValue) break;
                v = BooleanUtils.toBooleanObject((String)strUntypedValue);
                break;
            }
            case 2: {
                if (isNumberUntypedValue) {
                    v = new Integer(numUntypedValue.intValue());
                    break;
                }
                if (!isStringUntypedValue) break;
                v = NumberUtils.createInteger((String)strUntypedValue);
                break;
            }
            case 3: {
                if (isNumberUntypedValue) {
                    v = new Double(numUntypedValue.doubleValue());
                    break;
                }
                if (!isStringUntypedValue) break;
                v = NumberUtils.createDouble((String)strUntypedValue);
                break;
            }
            case 1: {
                v = ObjectUtils.toString((Object)untypedValue);
                break;
            }
            case 6: {
                if (!isNumberUntypedValue) break;
                v = DateUtils.truncate((java.util.Date)new java.util.Date(numUntypedValue.longValue()), (int)5);
                break;
            }
            case 7: {
                if (!isNumberUntypedValue) break;
                v = new java.util.Date(numUntypedValue.longValue());
                break;
            }
            case 4: {
                if (isNumberUntypedValue) {
                    v = new Double(numUntypedValue.doubleValue());
                    break;
                }
                if (!isStringUntypedValue) break;
                v = NumberUtils.createDouble((String)strUntypedValue);
                break;
            }
            case 5: {
                if (isNumberUntypedValue) {
                    v = new Double(numUntypedValue.doubleValue());
                    break;
                }
                if (!isStringUntypedValue) break;
                v = NumberUtils.createDouble((String)strUntypedValue);
            }
        }
        return v;
    }

    public Object fromDataType(Class untypedValueClass, DataTypeEnum dataType, Object typedValue) {
        if (typedValue == null) {
            return null;
        }
        Class dataTypeClass = this.getJavaClass(dataType);
        if (untypedValueClass == null) {
            return typedValue;
        }
        if (ClassUtils.isAssignable((Class)dataTypeClass, (Class)untypedValueClass)) {
            return typedValue;
        }
        String strTypedValue = null;
        boolean isStringTypedValue = typedValue instanceof String;
        Number numTypedValue = null;
        boolean isNumberTypedValue = typedValue instanceof Number;
        Boolean boolTypedValue = null;
        boolean isBooleanTypedValue = typedValue instanceof Boolean;
        java.util.Date dateTypedValue = null;
        boolean isDateTypedValue = typedValue instanceof java.util.Date;
        if (isStringTypedValue) {
            strTypedValue = (String)typedValue;
        }
        if (isNumberTypedValue) {
            numTypedValue = (Number)typedValue;
        }
        if (isBooleanTypedValue) {
            boolTypedValue = (Boolean)typedValue;
        }
        if (isDateTypedValue) {
            dateTypedValue = (java.util.Date)typedValue;
        }
        Object v = null;
        if (String.class.equals(untypedValueClass)) {
            v = ObjectUtils.toString((Object)typedValue);
        } else if (BigDecimal.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = NumberUtils.createBigDecimal((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = new BigDecimal(numTypedValue.doubleValue());
            } else if (isBooleanTypedValue) {
                v = new BigDecimal(BooleanUtils.toInteger((boolean)boolTypedValue));
            } else if (isDateTypedValue) {
                v = new BigDecimal(dateTypedValue.getTime());
            }
        } else if (Boolean.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = BooleanUtils.toBooleanObject((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = BooleanUtils.toBooleanObject((int)numTypedValue.intValue());
            } else if (isDateTypedValue) {
                v = BooleanUtils.toBooleanObject((int)((int)dateTypedValue.getTime()));
            }
        } else if (Byte.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = Byte.valueOf(strTypedValue);
            } else if (isNumberTypedValue) {
                v = new Byte(numTypedValue.byteValue());
            } else if (isBooleanTypedValue) {
                v = new Byte((byte)BooleanUtils.toInteger((boolean)boolTypedValue));
            } else if (isDateTypedValue) {
                v = new Byte((byte)dateTypedValue.getTime());
            }
        } else if ([B.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = strTypedValue.getBytes();
            }
        } else if (Double.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = NumberUtils.createDouble((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = new Double(numTypedValue.doubleValue());
            } else if (isBooleanTypedValue) {
                v = new Double(BooleanUtils.toInteger((boolean)boolTypedValue));
            } else if (isDateTypedValue) {
                v = new Double(dateTypedValue.getTime());
            }
        } else if (Float.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = NumberUtils.createFloat((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = new Float(numTypedValue.floatValue());
            } else if (isBooleanTypedValue) {
                v = new Float(BooleanUtils.toInteger((boolean)boolTypedValue));
            } else if (isDateTypedValue) {
                v = new Float(dateTypedValue.getTime());
            }
        } else if (Integer.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = NumberUtils.createInteger((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = new Integer(numTypedValue.intValue());
            } else if (isBooleanTypedValue) {
                v = BooleanUtils.toIntegerObject((boolean)boolTypedValue);
            } else if (isDateTypedValue) {
                v = new Integer((int)dateTypedValue.getTime());
            }
        } else if (Long.class.equals(untypedValueClass)) {
            if (isStringTypedValue) {
                v = NumberUtils.createLong((String)strTypedValue);
            } else if (isNumberTypedValue) {
                v = new Long(numTypedValue.longValue());
            } else if (isBooleanTypedValue) {
                v = new Long(BooleanUtils.toInteger((boolean)boolTypedValue));
            } else if (isDateTypedValue) {
                v = new Long(dateTypedValue.getTime());
            }
        } else if (Date.class.equals(untypedValueClass)) {
            if (isNumberTypedValue) {
                v = new Date(numTypedValue.longValue());
            } else if (isDateTypedValue) {
                v = new Date(dateTypedValue.getTime());
            }
        } else if (Time.class.equals(untypedValueClass)) {
            if (isNumberTypedValue) {
                v = new Time(numTypedValue.longValue());
            } else if (isDateTypedValue) {
                v = new Time(dateTypedValue.getTime());
            }
        } else if (Timestamp.class.equals(untypedValueClass)) {
            if (isNumberTypedValue) {
                v = new Timestamp(numTypedValue.longValue());
            } else if (isDateTypedValue) {
                v = new Timestamp(dateTypedValue.getTime());
            }
        } else if (java.util.Date.class.equals(untypedValueClass) && isNumberTypedValue) {
            v = new java.util.Date(numTypedValue.longValue());
        }
        return v;
    }
}

